/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.repository.UserProfiles;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/email")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class EmailResource {
    private UserProfiles userProfiles;

    @Autowired
    public EmailResource(UserProfiles userProfiles) {
        this.userProfiles = userProfiles;
    }

    @GET
    public String email() {
        UserProfile userProfile = this.userProfiles.findByLogin(Permissions.getAuthenticatedUserName());
        return userProfile.getEmail();
    }

    @PUT
    public void save(String email) {
        UserProfile userProfile = this.userProfiles.findByLogin(Permissions.getAuthenticatedUserName());
        userProfile.setEmail(email);
        this.userProfiles.save(userProfile);
    }
}

