/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.rest.api.UserResource;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.DeployitServers;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures")
@Controller
@NoCache
public class FixturesResource {
    private static final String USER_PATH = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users/";
    private RepositoryService repositoryService;
    private UserResource userResource;
    private DeployitServers deployitServers;
    private PermissionChecker permissions;

    @Autowired
    public FixturesResource(RepositoryService repositoryService, UserResource userResource, DeployitServers deployitServers, PermissionChecker permissions) {
        this.repositoryService = repositoryService;
        this.userResource = userResource;
        this.deployitServers = deployitServers;
        this.permissions = permissions;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    public void createEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.create(entities.toArray(new ConfigurationItem[entities.size()]));
    }

    @DELETE
    public void deleteReleases() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.deleteAll(Release.class);
    }

    private void deleteAll(Class<? extends ConfigurationItem> ciClass) {
        this.permissions.check(PlatformPermissions.ADMIN);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(ciClass));
        List items = this.repositoryService.listEntities(query);
        List ids = Lists.transform((List)items, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        });
        this.repositoryService.delete(ids.toArray(new String[ids.size()]));
    }

    @Path(value="{id}")
    @DELETE
    public void deleteApplicationEntity(@PathParam(value="id") @IdParam String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.delete(new String[]{id});
    }

    @Path(value="/configuration/{id}")
    @DELETE
    public void deleteConfigurationDirectory(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.repositoryService.delete(new String[]{"Configuration/" + id});
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/servers/")
    @POST
    public void createServers(List<DeployitServerDefinition> deployitServerDefinitions) {
        this.permissions.check(PlatformPermissions.ADMIN);
        for (DeployitServerDefinition deployitServerDefinition : deployitServerDefinitions) {
            this.deployitServers.addServer(deployitServerDefinition);
        }
    }

    @Path(value="/servers/")
    @DELETE
    public void deleteServers() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.deleteAll(DeployitServerDefinition.class);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/user")
    @POST
    public void createUser(User user) {
        this.permissions.check(PlatformPermissions.ADMIN);
        user.setAdmin(false);
        this.userResource.create(user.getUsername(), user);
    }

    @Path(value="/user/{login}")
    @DELETE
    public void deleteUser(@PathParam(value="login") String login) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.userResource.delete(login);
        this.repositoryService.delete(new String[]{USER_PATH + login});
    }

    @Path(value="/calendar")
    @DELETE
    public void deleteCalendar() {
        this.repositoryService.delete(new String[]{"/Configuration/Calendar"});
    }

    @Path(value="/cis")
    @DELETE
    public void deleteCIs(List<ConfigurationItem> cis) {
        this.permissions.check(PlatformPermissions.ADMIN);
        for (ConfigurationItem ci : cis) {
            this.repositoryService.delete(new String[]{ci.getId()});
        }
    }

    @Path(value="/userProfile")
    @GET
    public Response searchUserProfile(@QueryParam(value="name") String userName, @QueryParam(value="email") String userEmail) {
        this.permissions.check(PlatformPermissions.ADMIN);
        String id = USER_PATH + userName;
        if (!this.repositoryService.exists(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        UserProfile profile = (UserProfile)this.repositoryService.read(id);
        return profile.getEmail().equals(userEmail) ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

