/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.rest.api.PermissionResource;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.UserProfiles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/login")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class LoginResource {
    private PermissionResource permissionResource;
    private UserProfiles userProfiles;
    private Releases releases;

    @Autowired
    public LoginResource(PermissionResource permissionResource, UserProfiles userProfiles, Releases releases) {
        this.permissionResource = permissionResource;
        this.userProfiles = userProfiles;
        this.releases = releases;
    }

    @GET
    public Map<String, Collection<String>> login() {
        this.userProfiles.ensureUpToDate(Permissions.getAuthenticatedUserName());
        Map<String, Collection<String>> myLocalPermissions = this.releases.getMyGrantedPermissions();
        Map myGlobalPermissions = this.permissionResource.getMyGrantedPermissions();
        HashMap allPermissions = Maps.newHashMap();
        allPermissions.putAll(myLocalPermissions);
        allPermissions.putAll(myGlobalPermissions);
        return allPermissions;
    }
}

