/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.CalendarResource;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.ReleaseFullView;
import com.xebialabs.xlrelease.views.ReleasePermissionsView;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TeamView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class ReleaseResource {
    private static final Predicate<Task> IS_AUTOMATED_IN_PROGRESS = new Predicate<Task>(){

        public boolean apply(Task task) {
            boolean isAutomated = (Boolean)task.getProperty("automated");
            return isAutomated && task.isStarted();
        }
    };
    private RepositoryService repositoryService;
    private Releases releases;
    private PermissionChecker permissions;
    private ReleaseEditor releaseEditor;
    private ExecutionService executionService;
    private Phases phases;
    private CalendarResource calendarResource;

    @Autowired
    public ReleaseResource(Releases releases, PermissionChecker permissions, RepositoryService repositoryService, ReleaseEditor releaseEditor, ExecutionService executionService, Phases phases, CalendarResource calendarResource) {
        this.releases = releases;
        this.permissions = permissions;
        this.repositoryService = repositoryService;
        this.releaseEditor = releaseEditor;
        this.executionService = executionService;
        this.phases = phases;
        this.calendarResource = calendarResource;
    }

    @GET
    @Path(value="templates")
    public List<ReleaseFullView> getTemplates() {
        List<Release> templates = this.permissions.filter(this.releases.withStatus(ReleaseStatus.TEMPLATE), XLReleasePermissions.VIEW_TEMPLATE);
        return Lists.transform(templates, ReleaseFullView.TO_RELEASE_FULL_VIEW);
    }

    @POST
    @Path(value="templates")
    public ReleaseFullView createTemplate(ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        Release release = this.releaseEditor.createTemplate(releaseForm.getTitle(), releaseForm.getDescription(), releaseForm.getTags());
        return new ReleaseFullView(release);
    }

    @POST
    @Path(value="templates/copy")
    public ReleaseFullView copyTemplate(ReleaseForm templateForm) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        Release release = this.releases.copyTemplate(templateForm.getTemplateId(), templateForm.getTitle(), templateForm.getDescription());
        return new ReleaseFullView(release);
    }

    @DELETE
    @Path(value="templates/{templateId}")
    public Response deleteTemplate(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        this.repositoryService.delete(new String[]{templateId});
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="templates/{templateId}")
    public ReleaseFullView updateTemplate(@PathParam(value="templateId") @IdParam String templateId, ReleaseForm releaseForm) {
        Object object = ReleaseLock.of(templateId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
            Release template = this.releaseEditor.updateTemplate(templateId, releaseForm, releaseForm.getTags());
            return new ReleaseFullView(template);
        }
    }

    @GET
    public List<ReleaseFullView> getReleases(@QueryParam(value="planned") boolean planned, @QueryParam(value="active") boolean inProgress, @QueryParam(value="completed") boolean completed, @QueryParam(value="onlyMine") boolean myRelease, @QueryParam(value="onlyFlagged") boolean onlyFlagged, @QueryParam(value="filter") String filter) {
        List<Release> viewableReleases = this.permissions.filter(this.releases.findAll(planned, inProgress, completed, myRelease, onlyFlagged, filter), XLReleasePermissions.VIEW_RELEASE);
        Collections.sort(viewableReleases, PlanItem.BY_TITLE);
        return Lists.transform(viewableReleases, ReleaseFullView.TO_RELEASE_FULL_VIEW);
    }

    @POST
    public ReleaseFullView createRelease(ReleaseForm releaseForm) {
        Release release;
        if (!releaseForm.hasValidDates()) {
            throw new BadRequestException("Scheduled start date must be before due date");
        }
        if (releaseForm.isFromTemplate()) {
            this.permissions.checkIsAllowedToCreateReleaseFromTemplate(releaseForm.getTemplateId());
            release = this.releaseEditor.createFromTemplate(releaseForm.getTemplateId(), releaseForm.toRelease());
        } else {
            this.permissions.check(XLReleasePermissions.CREATE_RELEASE);
            release = this.releaseEditor.createWithoutTemplate(releaseForm.toRelease());
        }
        return new ReleaseFullView(release);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{releaseId}")
    public ReleaseFullView updateRelease(@PathParam(value="releaseId") @IdParam String releaseId, ReleaseForm releaseForm) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
            Release release = this.releaseEditor.updateRelease(releaseId, releaseForm);
            return new ReleaseFullView(release);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/start")
    public ReleaseFullView startRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
            Release release = this.executionService.start(releaseId);
            return new ReleaseFullView(release);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/abort")
    public ReleaseFullView abortRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
            this.checkNoAutomatedTaskRunning(releaseId, "You can not abort a release when an automated task is running");
            Release release = this.executionService.abort(releaseId);
            return new ReleaseFullView(release);
        }
    }

    @GET
    @Path(value="{releaseId}")
    public ReleaseFullView getRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        Release release = this.releases.findById(releaseId);
        return new ReleaseFullView(release);
    }

    @GET
    @Path(value="{releaseId}/calendar")
    public Response exportToCalendar(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.VIEW_RELEASE, releaseId);
        String downloadToken = this.calendarResource.register(releaseId);
        return Response.ok((Object)downloadToken).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/phases/move")
    public PhaseFullView movePhase(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.checkEdit(releaseId);
            Release release = this.releases.findById(releaseId);
            Phase movedPhase = this.releaseEditor.movePhase(release, movementIndexes);
            return new PhaseFullView(movedPhase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/tasks/move")
    public TaskFullView moveTask(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.checkEdit(releaseId);
            Task movedTask = this.releaseEditor.moveTask(movementIndexes);
            return new TaskFullView(movedTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/phases/add")
    public PhaseFullView addPhase(@PathParam(value="releaseId") @IdParam String releaseId) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.checkEdit(releaseId);
            Phase phase = this.phases.create(releaseId);
            return new PhaseFullView(phase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{releaseId}/tasks/duplicate/{taskId}")
    public TaskFullView duplicateTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String originTaskId) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.checkEdit(releaseId);
            Task duplicateTask = this.releaseEditor.duplicateTask(originTaskId);
            return new TaskFullView(duplicateTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{releaseId}/phases/duplicate/{phaseId}")
    public PhaseFullView duplicatePhase(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="phaseId") @IdParam String originPhaseId) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.checkEdit(releaseId);
            Release release = this.releases.findById(releaseId);
            Phase duplicatePhase = this.releaseEditor.duplicatePhase(release, originPhaseId);
            return new PhaseFullView(duplicatePhase);
        }
    }

    @GET
    @Path(value="{releaseId}/logs")
    public List<ActivityLogEntry> getLogs(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        Release release = this.releases.findById(releaseId);
        ArrayList activityLogEntries = Lists.newArrayList(release.getActivityLogEntries());
        Collections.sort(activityLogEntries, Collections.reverseOrder(ActivityLogEntry.BY_EVENT_TIME));
        return activityLogEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{releaseId}/variables")
    public List<Variable> updateVariables(@PathParam(value="releaseId") @IdParam String releaseId, List<Variable> variables) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
            Release release = this.releaseEditor.updateVariables(releaseId, variables);
            return Variable.mapToList(release.getVariableValues());
        }
    }

    @GET
    @Path(value="{releaseId}/permissions")
    public ReleasePermissionsView getPermissions(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.permissions.checkEdit(releaseId);
        Release release = this.releases.findById(releaseId);
        List<String> permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
        return new ReleasePermissionsView(permissions, release);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{releaseId}/permissions")
    public ReleasePermissionsView updatePermissions(@PathParam(value="releaseId") @IdParam String releaseId, List<TeamView> teamViews) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(PlatformPermissions.EDIT_SECURITY);
            this.permissions.checkEdit(releaseId);
            Release release = this.releaseEditor.updatePermissions(releaseId, Lists.transform(teamViews, TeamView.TO_TEAM));
            List<String> permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
            return new ReleasePermissionsView(permissions, release);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/restartPhasesFrom/{phaseId}")
    public ReleaseFullView restartPhasesFrom(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="phaseId") @IdParam String phaseId) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
            this.checkNoAutomatedTaskRunning(releaseId, "You can not restart phases when an automated task is running");
            Release release = this.releaseEditor.restartPhasesFrom(releaseId, phaseId);
            return new ReleaseFullView(release);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{releaseId}/resume")
    public ReleaseFullView resume(@PathParam(value="releaseId") @IdParam String releaseId, List<Variable> variables) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
            this.releaseEditor.updateVariables(releaseId, variables);
            Release release = this.executionService.resume(releaseId);
            return new ReleaseFullView(release);
        }
    }

    private void checkNoAutomatedTaskRunning(String releaseId, String message) {
        Release release = this.releases.findById(releaseId);
        if (!Collections2.filter(release.getAllTasks(), IS_AUTOMATED_IN_PROGRESS).isEmpty()) {
            throw new IllegalStateException(message);
        }
    }
}

