/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReportTimeFrame;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.views.Point;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class ReportResource {
    private ReportServiceCache reportService;
    private PermissionChecker permissions;

    @Autowired
    public ReportResource(ReportServiceCache reportService, PermissionChecker permissions) {
        this.reportService = reportService;
        this.permissions = permissions;
    }

    @GET
    @Path(value="/releases/duration")
    public Map<String, List<Point>> getReleaseDuration(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") ReportTimeFrame since) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getReleaseDurationSeries(since);
    }

    @GET
    @Path(value="/most-involved-people")
    public List<UserParticipation> getTopTenPeopleMostInvolved(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") ReportTimeFrame since) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopTenPeopleMostInvolved(since);
    }

    @GET
    @Path(value="/longest-tasks")
    public List<TaskDuration> getTopTenLongestTasks(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") ReportTimeFrame since) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopTenLongestTasks(since);
    }

    @GET
    @Path(value="/releases/automation")
    public Map<String, List<Point>> getReleaseAutomation(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") ReportTimeFrame since) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getReleaseAutomationSeries(since);
    }

    @GET
    @Path(value="/longest-phases")
    public List<PhaseDuration> getTopTenLongestPhases(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") ReportTimeFrame since) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getTopTenLongestPhases(since);
    }

    @GET
    @Path(value="/releases/number-by-month")
    public List<Point> getNumberOfReleaseByMonth(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") ReportTimeFrame since) {
        this.permissions.check(XLReleasePermissions.VIEW_REPORTS);
        return this.reportService.getNumberOfReleaseByMonth(since);
    }
}

