/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.customscripts.PythonScriptDefinitions;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskFilter;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notification.Notifications;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskForm;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/tasks")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class TaskResource {
    private Releases releases;
    private Tasks tasks;
    private Comments comments;
    private RepositoryService repositoryService;
    private Notifications notifications;
    private PermissionChecker permissions;
    private ExecutionService executionService;
    private PythonScriptDefinitions pythonScriptDefinitions;
    private static final Function<Task, Release> TO_RELEASE = new Function<Task, Release>(){

        public Release apply(Task task) {
            return task.getPhase().getRelease();
        }
    };
    private static final Function<Map.Entry<Release, Collection<Task>>, ReleaseTasks> TO_RELEASE_TASKS = new Function<Map.Entry<Release, Collection<Task>>, ReleaseTasks>(){

        public ReleaseTasks apply(Map.Entry<Release, Collection<Task>> entry) {
            return new ReleaseTasks(entry.getKey(), Lists.newArrayList((Iterable)entry.getValue()));
        }
    };

    @Autowired
    public TaskResource(Releases releases, Tasks tasks, Comments comments, RepositoryService repositoryService, Notifications notifications, PermissionChecker permissions, ExecutionService executionService, PythonScriptDefinitions customScriptTypes) {
        this.releases = releases;
        this.tasks = tasks;
        this.comments = comments;
        this.repositoryService = repositoryService;
        this.notifications = notifications;
        this.permissions = permissions;
        this.executionService = executionService;
        this.pythonScriptDefinitions = customScriptTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{containerId}")
    public TaskFullView addTask(@PathParam(value="containerId") @IdParam String containerId, TaskForm taskForm) {
        Object object = ReleaseLock.of(containerId);
        synchronized (object) {
            String releaseId = Ids.releaseIdFrom(containerId);
            this.permissions.checkView(releaseId);
            this.permissions.checkEdit(releaseId);
            this.permissions.checkEditTask(releaseId);
            Task task = this.tasks.create(containerId, taskForm.toTask());
            return new TaskFullView(task);
        }
    }

    @GET
    @Path(value="{taskId}")
    public TaskFullView getTask(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = this.tasks.findById(taskId);
        return new TaskFullView(task);
    }

    @GET
    public List<ReleaseTasks> getTasksByRelease(@QueryParam(value="active") boolean active, @QueryParam(value="assignedToMe") boolean assignedToMe, @QueryParam(value="assignedToMyTeams") boolean assignedToMyTeams, @QueryParam(value="assignedToOthers") boolean assignedToOthers, @QueryParam(value="notAssigned") boolean notAssigned, @QueryParam(value="search") String search) {
        String username = Permissions.getAuthenticatedUserName();
        List<Release> activeReleases = this.releases.active();
        TaskFilter taskFilter = new TaskFilter(active, assignedToMe, assignedToMyTeams, assignedToOthers, notAssigned, search);
        List<Task> tasks = taskFilter.filter(username, activeReleases);
        ImmutableListMultimap tasksByRelease = Multimaps.index(tasks, TO_RELEASE);
        ArrayList releaseTasks = Lists.newArrayList((Iterable)Collections2.transform(tasksByRelease.asMap().entrySet(), TO_RELEASE_TASKS));
        Collections.sort(releaseTasks, ReleaseTasks.BY_TITLE);
        return releaseTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{taskId}/complete")
    public Response completeTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.checkIsAllowedToWorkOnTask(taskId);
            this.checkIsStatusUpdatable(taskId, "You can not complete a running automated task");
            this.executionService.markTaskAsDone(TaskStatus.COMPLETED, taskId, comment.getText());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{taskId}/skip")
    public Response skipTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory");
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(taskId));
            this.checkIsStatusUpdatable(taskId, "You can not skip a running automated task");
            this.executionService.markTaskAsDone(TaskStatus.SKIPPED, taskId, comment.getText());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{taskId}/fail")
    public Response failTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory");
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.checkIsAllowedToWorkOnTask(taskId);
            this.checkIsStatusUpdatable(taskId, "You can not fail a running automated task");
            this.executionService.fail(taskId, comment.getText());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{taskId}/retry")
    public Response retryTask(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(taskId));
            this.permissions.checkIsReleaseOwner(Ids.releaseIdFrom(taskId));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory");
            this.executionService.retry(taskId, comment.getText());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{taskId}/startNow")
    public Response startNow(@PathParam(value="taskId") @IdParam String taskId, CommentView comment) {
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(taskId));
            this.executionService.startPendingTask(taskId, comment.getText());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    @GET
    @Path(value="{taskId}/comments")
    public List<CommentView> getCommentsOfTask(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = (Task)this.repositoryService.read(taskId);
        return Lists.transform(task.getComments(), CommentView.TO_COMMENT_VIEW);
    }

    @GET
    @Path(value="{taskId}/teams/assignable")
    public List<Team> getAssignableTeams(@PathParam(value="taskId") @IdParam String taskId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom(taskId));
        this.permissions.checkReassignTask(Ids.releaseIdFrom(taskId));
        Release release = this.releases.containingTask(taskId);
        return release.getTeams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{taskId}/comments")
    public CommentView addComment(@PathParam(value="taskId") @IdParam String taskId, CommentView commentView) {
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.checkIsAllowedToWorkOnTask(taskId);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentView.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory");
            Comment comment = this.comments.create(taskId, commentView.getText(), User.AUTHENTICATED_USER, true);
            return new CommentView(comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{taskId}")
    public TaskFullView updateTask(@PathParam(value="taskId") @IdParam String taskId, TaskFullView updatedTask) {
        Preconditions.checkArgument((updatedTask.getFlag().getStatus() != null ? 1 : 0) != 0, (Object)"Flag status is mandatory");
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            boolean ownerChanged;
            this.permissions.checkEditTask(Ids.releaseIdFrom(taskId));
            Task task = this.tasks.findById(taskId);
            boolean ownerHasBeenReassigned = updatedTask.ownerHasBeenReassigned(task);
            boolean teamHasBeenReassigned = updatedTask.teamHasBeenReassigned(task);
            boolean taskWasAssigned = task.isAssigned();
            String previousOwner = task.getOwner();
            if (ownerHasBeenReassigned || teamHasBeenReassigned) {
                this.permissions.checkReassignTask(Ids.releaseIdFrom(taskId));
            }
            this.tasks.updateTaskWith(task, updatedTask);
            boolean bl = ownerChanged = ownerHasBeenReassigned && updatedTask.getOwner() != null;
            if (task.isActive() && ownerChanged) {
                this.notifications.notifyAssignedToOwner(task);
                if (taskWasAssigned) {
                    this.notifications.notifyTaskReassigned(task, previousOwner);
                } else {
                    this.notifications.notifyTaskPicked(task);
                }
            }
            return new TaskFullView(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{taskId}")
    public void deleteTask(@PathParam(value="taskId") @IdParam String taskId) {
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            this.permissions.checkEditTask(Ids.releaseIdFrom(taskId));
            this.permissions.checkEdit(Ids.releaseIdFrom(taskId));
            this.tasks.delete(taskId);
        }
    }

    @POST
    @Path(value="poll")
    public List<TaskFullView> poll(@QueryParam(value="id") @IdParam List<String> taskIds) {
        List<Task> taskList = this.tasks.findById(taskIds);
        return Lists.transform(taskList, TaskFullView.TO_TASK_FULL_VIEW);
    }

    @GET
    @Path(value="python-script-definitions")
    public Collection<PythonScriptDefinition> getPythonScriptDefinitions() {
        return Collections2.transform(this.pythonScriptDefinitions.getTypes(), PythonScriptDefinition.TO_METADATA);
    }

    @GET
    @Path(value="python-script-definitions/{scriptDefinitionType}")
    public PythonScriptDefinition getCustomScriptProperties(@PathParam(value="scriptDefinitionType") String scriptDefinitionType) {
        return new PythonScriptDefinition(Type.valueOf((String)scriptDefinitionType));
    }

    private void checkIsStatusUpdatable(String taskId, String message) {
        Task task = this.tasks.findById(taskId);
        boolean isAutomated = (Boolean)task.getProperty("automated");
        if (isAutomated && task.isStarted()) {
            throw new IllegalArgumentException(message);
        }
    }
}

