/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.repository.UserProfiles;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class UserProfilesResource {
    private UserProfiles userProfiles;

    @Autowired
    public UserProfilesResource(UserProfiles userProfiles) {
        this.userProfiles = userProfiles;
    }

    @GET
    public List<String> getUsers() {
        ArrayList userNames = Lists.newArrayList((Iterable)Lists.transform(this.userProfiles.findAll(), UserProfile.TO_USER_NAME));
        Collections.sort(userNames, Collator.getInstance());
        return userNames;
    }
}

