/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.builder.CustomScriptTaskBuilder;
import com.xebialabs.xlrelease.builder.DefaultTaskBuilder;
import com.xebialabs.xlrelease.builder.DeployitTaskBuilder;
import com.xebialabs.xlrelease.builder.GateTaskBuilder;
import com.xebialabs.xlrelease.builder.NotificationTaskBuilder;
import com.xebialabs.xlrelease.builder.ParallelGroupBuilder;
import com.xebialabs.xlrelease.builder.ScriptTaskBuilder;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class TaskBuilder<T extends Task, S extends TaskBuilder<T, S>> {
    private String id;
    private String title;
    private TaskStatus status;
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private String owner;
    private String team;
    private PlanItem container;
    private String description;
    private Date dueDate;
    private Date scheduledStartDate;
    private Date startDate;
    private Date endDate;
    private List<Comment> comments = Collections.emptyList();

    public static DefaultTaskBuilder newTask() {
        return new DefaultTaskBuilder();
    }

    public static GateTaskBuilder newGateTask() {
        return new GateTaskBuilder();
    }

    public static DeployitTaskBuilder newDeployitTask() {
        return new DeployitTaskBuilder();
    }

    public static NotificationTaskBuilder newNotificationTask() {
        return new NotificationTaskBuilder();
    }

    public static ScriptTaskBuilder newScriptTask() {
        return new ScriptTaskBuilder();
    }

    public static ParallelGroupBuilder newParallelGroup() {
        return new ParallelGroupBuilder();
    }

    public static CustomScriptTaskBuilder newCustomScript(String scriptDefinitionType) {
        return new CustomScriptTaskBuilder(scriptDefinitionType);
    }

    protected final S self() {
        return (S)this;
    }

    public S withId(String id) {
        this.id = id;
        return this.self();
    }

    public S withTitle(String title) {
        this.title = title;
        return this.self();
    }

    public S withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this.self();
    }

    public S withStatus(TaskStatus status) {
        this.status = status;
        if (status == TaskStatus.IN_PROGRESS) {
            this.startDate = new Date();
        } else if (status != null && status.isDone()) {
            this.endDate = new Date();
        }
        return this.self();
    }

    public S withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this.self();
    }

    public S withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this.self();
    }

    public S withOwner(String owner) {
        this.owner = owner;
        return this.self();
    }

    public S withTeam(String team) {
        this.team = team;
        return this.self();
    }

    public S withContainer(PlanItem item) {
        this.container = item;
        return this.self();
    }

    public S withDescription(String description) {
        this.description = description;
        return this.self();
    }

    public S withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this.self();
    }

    public S withStartDate(Date startDate) {
        this.startDate = startDate;
        return this.self();
    }

    public S withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this.self();
    }

    public S withEndDate(Date endDate) {
        this.endDate = endDate;
        return this.self();
    }

    public S withComments(Comment ... comments) {
        this.comments = Lists.newArrayList((Object[])comments);
        return this.self();
    }

    protected void setFields(T task) {
        task.setId(this.id);
        ((Task)((Object)task)).setStatus(this.status);
        ((PlanItem)((Object)task)).setFlagStatus(this.flagStatus);
        ((PlanItem)((Object)task)).setFlagComment(this.flagComment);
        ((PlanItem)((Object)task)).setTitle(this.title);
        ((PlanItem)((Object)task)).setOwner(this.owner);
        ((Task)((Object)task)).setTeam(this.team);
        ((Task)((Object)task)).setContainer(this.container);
        ((PlanItem)((Object)task)).setDescription(this.description);
        ((PlanItem)((Object)task)).setDueDate(this.dueDate);
        ((PlanItem)((Object)task)).setStartDate(this.startDate);
        ((PlanItem)((Object)task)).setScheduledStartDate(this.scheduledStartDate);
        ((PlanItem)((Object)task)).setEndDate(this.endDate);
        ((Task)((Object)task)).getComments().addAll(this.comments);
    }

    public abstract T build();
}

