/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PlanItem
extends BaseConfigurationItem {
    @Property
    private String title;
    @Property(required=false)
    private String description;
    @Property(required=false)
    private String owner;
    @Property(required=false)
    private Date dueDate;
    @Property(required=false)
    private Date startDate;
    @Property(required=false)
    private Date scheduledStartDate;
    @Property(required=false)
    private Date endDate;
    @Property
    private FlagStatus flagStatus = FlagStatus.OK;
    @Property(required=false)
    private String flagComment;
    public static final Comparator<PlanItem> BY_TITLE = new Comparator<PlanItem>(){

        @Override
        public int compare(PlanItem left, PlanItem right) {
            String leftTitle = Strings.nullToEmpty((String)left.getTitle());
            String rightTitle = Strings.nullToEmpty((String)right.getTitle());
            return ComparisonChain.start().compare((Comparable)((Object)leftTitle), (Comparable)((Object)rightTitle)).result();
        }
    };

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String value) {
        this.owner = value;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean hasOwner(String releaseOwner) {
        return this.getOwner() != null && this.getOwner().equals(releaseOwner);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date value) {
        this.dueDate = value;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        this.endDate = value;
    }

    public FlagStatus getFlagStatus() {
        return this.flagStatus;
    }

    public void setFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
    }

    public String getFlagComment() {
        return this.flagComment;
    }

    public void setFlagComment(String flagComment) {
        this.flagComment = flagComment;
    }

    public boolean isFlagged() {
        return FlagStatus.OK != this.flagStatus;
    }

    public abstract List<Task> getAllTasks();

    public abstract void accept(ReleaseVisitor var1);

    public abstract boolean isDone();

    public abstract boolean isDefunct();

    public abstract boolean isAborted();

    public abstract Release getRelease();

    public abstract String getDisplayPath();

    protected String replaceAll(String raw, Map<String, String> replacements, Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        String result = raw;
        if (!Strings.isNullOrEmpty((String)result)) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                result = result.replace(entry.getKey(), entry.getValue());
            }
            Set<String> remainingVariables = Variable.collectVariables(result);
            unresolvedVariables.addAll(remainingVariables);
            if (freezeEvenIfUnresolved) {
                for (String remainingVariable : remainingVariables) {
                    result = Variable.freezeUnresolvedVariable(result, remainingVariable);
                }
            }
        }
        return result;
    }
}

