/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.PythonScript;
import java.util.Collection;

public class PythonScriptDefinition {
    private String typeName;
    private String displayGroup;
    private String displayName;
    private Collection<PropertyDescriptor> inputProperties;
    private Collection<PropertyDescriptor> outputProperties;
    public static final Function<Type, PythonScriptDefinition> TO_METADATA = new Function<Type, PythonScriptDefinition>(){

        public PythonScriptDefinition apply(Type type) {
            return new PythonScriptDefinition(type);
        }
    };

    public PythonScriptDefinition(Type type) {
        Preconditions.checkArgument((boolean)type.getDescriptor().isAssignableTo(PythonScript.class));
        this.typeName = type.toString();
        this.displayGroup = this.capitalizeFirstLetter(type.getPrefix().toLowerCase());
        this.displayName = this.capitalizeFirstLetter(Strings.deCamelize((String)type.getName()).toLowerCase());
        Collection properties = type.getDescriptor().getPropertyDescriptors();
        this.inputProperties = Collections2.filter((Collection)properties, PythonScript.IS_INPUT_PROPERTY);
        this.outputProperties = Collections2.filter((Collection)properties, PythonScript.IS_OUTPUT_PROPERTY);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDisplayGroup() {
        return this.displayGroup;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<PropertyDescriptor> getInputProperties() {
        return this.inputProperties;
    }

    public Collection<PropertyDescriptor> getOutputProperties() {
        return this.outputProperties;
    }

    private String capitalizeFirstLetter(String text) {
        StringBuilder stringBuilder = new StringBuilder(text.length());
        stringBuilder.append(Character.toUpperCase(text.charAt(0)));
        stringBuilder.append(text.substring(1));
        return stringBuilder.toString();
    }
}

