/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;

public enum ReleaseActivities {
    TEMPLATE_CREATED("Created template"),
    TEMPLATE_DUPLICATED("Duplicated template to '%s'"),
    RELEASE_TITLE_UPDATED("Changed title from '%s' to '%s'"),
    RELEASE_DESCRIPTION_UPDATED("Changed description from '%s' to '%s'"),
    RELEASE_DUE_DATE_UPDATED("Changed due date from '%s' to '%s'"),
    RELEASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date from '%s' to '%s'"),
    RELEASE_OWNER_UPDATED("Changed owner from %s to %s"),
    RELEASE_VARIABLES_UPDATED("Updated variables:\n%s"),
    RELEASE_VARIABLE_UPDATED("Updated release variable '%s' to '%s'"),
    RELEASE_TAGS_UPDATED("Updated tags to:\n%s"),
    RELEASE_FLAG_STATUS_UPDATED("Changed flag status from '%s' to '%s'"),
    RELEASE_FLAG_COMMENT_UPDATED("Changed flag comment from '%s' to '%s'"),
    COMMENT_ADDED("Added a comment '%s' on task '%s'"),
    COMMENT_UPDATED("Updated comment '%s' to '%s' on task '%s'"),
    PHASE_CREATED("Created Phase '%s'"),
    PHASE_RENAMED("Renamed Phase '%s' to '%s'"),
    PHASE_DESCRIPTION_UPDATED("Changed description of Phase '%s' from '%s' to '%s'"),
    PHASE_DUE_DATE_UPDATED("Changed due date of Phase '%s' from '%s' to '%s'"),
    PHASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start of Phase '%s' date from '%s' to '%s'"),
    PHASE_COLOR_CHANGED("Changed color of Phase '%s' from '%s' to '%s'"),
    PHASE_MOVED("Moved Phase '%s'"),
    PHASE_DELETED("Deleted Phase '%s'"),
    PHASE_DUPLICATED("Duplicated Phase '%s'"),
    PHASE_STARTED("Started Phase '%s'"),
    PHASE_FAILED("Failed Phase '%s'"),
    PHASE_FAILING("Phase '%s' started failing"),
    PHASE_RESTARTED("Restarted Phase '%s'"),
    PHASE_COMPLETED("Completed Phase '%s'"),
    PHASE_CLOSED("Closed Phase '%s' and skipped all its tasks"),
    TASK_CREATED("Created Task '%s' of type '%s'"),
    TASK_MOVED_BETWEEN_CONTAINERS("Moved Task '%s' from '%s' to '%s'"),
    TASK_MOVED_WITHIN_CONTAINER("Moved Task '%s' within '%s'"),
    TASK_DELETED("Deleted Task '%s'"),
    TASK_TITLE_UPDATED("Changed title of Task '%s' from '%s' to '%s'"),
    TASK_DESCRIPTION_UPDATED("Changed description of Task '%s' from '%s' to '%s'"),
    TASK_OWNER_UPDATED("Changed owner of Task '%s' from %s to %s"),
    TASK_TASK_TEAM_UPDATED("Changed team of Task '%s' from %s to %s"),
    TASK_DUE_DATE_UPDATED("Changed due date of Task '%s' from '%s' to '%s'"),
    TASK_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Task '%s' from '%s' to '%s'"),
    TASK_DEPLOYIT_SERVER_UPDATED("Changed Deployit server of Task '%s' from '%s' to '%s'"),
    TASK_FLAG_STATUS_UPDATED("Flagged Task '%s' from '%s' to '%s'"),
    TASK_FLAG_COMMENT_UPDATED("Changed flag status of Task '%s' from '%s' to '%s'"),
    TASK_DEPLOYIT_PACKAGE_UPDATED("Changed Deployment Package of Task '%s' from '%s' to '%s'"),
    TASK_DEPLOYIT_ENVIRONMENT_UPDATED("Changed Deployment Environment of Task '%s' from '%s' to '%s'"),
    TASK_DEPLOYIT_USERNAME_UPDATED("Changed Deployment Username of Task '%s' from '%s' to '%s'"),
    TASK_DEPLOYIT_PASSWORD_UPDATED("Changed Deployment Password of Task '%s'"),
    TASK_DUPLICATED("Duplicated Task '%s'"),
    TASK_NOTIFICATION_ADDRESSES_UPDATED("Changed Notification addresses of Task '%s' from '%s' to '%s'"),
    TASK_NOTIFICATION_SUBJECT_UPDATED("Changed Notification subject of Task '%s' from '%s' to '%s'"),
    TASK_NOTIFICATION_BODY_UPDATED("Changed Notification body of Task '%s' from '%s' to '%s'"),
    TASK_SCRIPT_UPDATED("Changed Script of Task '%s' from '%s' to '%s'"),
    TASK_INPUT_PROPERTY_UPDATED("Changed input property '%s' of Task '%s' from '%s' to '%s'"),
    TASK_INPUT_PROPERTY_PASSWORD_UPDATED("Changed input property '%s' of Task '%s'"),
    TASK_OUTPUT_PROPERTIES_UPDATED("Changed output property '%s' of Task '%s' from '%s' to '%s'"),
    TEAM_CREATED("Created Team '%s'"),
    TEAM_UPDATED("Updated Team '%s' with members '%s'"),
    TEAM_DELETED("Removed Team '%s'"),
    GATE_CONDITION_CREATED("Created Condition '%s' on gate '%s'"),
    GATE_CONDITION_TITLE_UPDATED("Updated title on Condition '%s' of gate '%s' from '%s' to '%s'"),
    GATE_CONDITION_FULLFILLED("Fullfilled Condition '%s' on gate '%s'"),
    GATE_CONDITION_UNFULLFILLED("Unfullfilled Condition '%s' on gate '%s'"),
    GATE_CONDITION_UPDATED("Updated Condition '%s' on gate '%s'"),
    GATE_CONDITION_DELETED("Deleted Condition '%s' from gate '%s'"),
    DEPENDENCY_CREATED("Added Dependency in gate '%s' on '%s'"),
    DEPENDENCY_UPDATED("Changed Dependency in gate '%s' on '%s' to '%s'"),
    DEPENDENCY_DELETED("Deleted Dependency in gate '%s' on '%s'"),
    RELEASE_CREATED_FROM_TEMPLATE("Created Release '%s' from template '%s'"),
    RELEASE_CREATED("Created Empty Release '%s'"),
    RELEASE_STARTED("Started Release"),
    RELEASE_FAILED("Failed Release"),
    RELEASE_FAILING("Release started failing"),
    RELEASE_RESTARTED("Restarted Release"),
    RELEASE_COMPLETED("Completed Release"),
    RELEASE_ABORTED("Aborted Release"),
    TASK_STARTED("Started Task '%s'"),
    TASK_DELAYED("Activated Task '%s' with a scheduled start date of '%s'"),
    TASK_COMPLETED("Completed Task '%s'"),
    TASK_SKIPPED("Skipped Task '%s'"),
    TASK_FAILED("Failed Task '%s': %s"),
    TASK_RESTARTED("Restarted Task '%s'"),
    TASK_FAILING("Task '%s' started failing"),
    PERMISSIONS_UPDATED("Updated permissions to:\n%s");

    private String message;

    private ReleaseActivities(String message) {
        this.message = message;
    }

    public ActivityLogEntry create(Object ... parameters) {
        return new ActivityLogEntry(this.name(), this.format(this.formatNulls(parameters)));
    }

    public String format(Object ... parameters) {
        return String.format(this.message, parameters);
    }

    private Object[] formatNulls(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (null != parameters[i]) continue;
            parameters[i] = "";
        }
        return parameters;
    }

    public String toString() {
        return this.message;
    }
}

