/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseActivitiesFormatter;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.PostStartAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Task
extends PlanItem {
    @Property(asContainment=true)
    private PlanItem container;
    @Property
    private TaskStatus status;
    @Property(required=false)
    private String team;
    @Property(asContainment=true, required=false)
    private List<Comment> comments = Lists.newArrayList();
    public static final Predicate<Task> DOES_NOT_BELONG_TO_TEMPLATE = new Predicate<Task>(){

        public boolean apply(Task task) {
            return !task.getRelease().isTemplate();
        }
    };

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public String getTeam() {
        return this.team;
    }

    public boolean hasTeam() {
        return this.team != null;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public PlanItem getContainer() {
        return this.container;
    }

    public void setContainer(PlanItem container) {
        this.container = container;
    }

    public Phase getPhase() {
        if (this.container instanceof Task) {
            return ((Task)this.container).getPhase();
        }
        if (this.container instanceof Phase) {
            return (Phase)this.container;
        }
        if (this.container == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type for container: " + ((Object)((Object)this.container)).getClass().getName());
    }

    public boolean hasTeamCi() {
        return this.getTeamCi() != null;
    }

    public Team getTeamCi() {
        for (Team teamCi : this.getRelease().getTeams()) {
            if (!teamCi.getTeamName().equals(this.team)) continue;
            return teamCi;
        }
        return null;
    }

    public Changes start() {
        return this.canStartNow() ? this.startNow(this.getId(), false) : this.delayStartup();
    }

    public boolean canStartNow() {
        return this.getScheduledStartDate() == null || new Date().after(this.getScheduledStartDate());
    }

    public Changes startPending(String targetId) {
        return this.startNow(targetId, true);
    }

    public Changes retry(String targetId) {
        if (this.getId().equals(targetId) && !this.isFailed()) {
            throw new IllegalStateException("Expected task to be failed");
        }
        return this.execute(targetId, ReleaseActivities.TASK_RESTARTED);
    }

    protected Changes startNow(String targetId, boolean shouldBePending) {
        if (shouldBePending && !this.isPending()) {
            throw new IllegalStateException("Expected task to be pending");
        }
        return this.execute(targetId, ReleaseActivities.TASK_STARTED);
    }

    protected Changes execute(String targetId, ReleaseActivities activity) {
        final TaskStatus previousStatus = this.status;
        this.checkOwnId(targetId);
        Changes changes = new Changes();
        this.status = TaskStatus.IN_PROGRESS;
        this.setStartDate(new Date());
        changes.update((ConfigurationItem)this, activity.create(this.getTitle()));
        Set<String> unresolvedVariables = this.freezeVariables(changes, false);
        if (!unresolvedVariables.isEmpty()) {
            String variableNames = Joiner.on((String)"', '").join(unresolvedVariables);
            changes.addAll(this.fail(this.getId(), FailureReasons.UNRESOLVED_VARIABLES.format(variableNames)));
        }
        changes.addPostStartAction(new PostStartAction(){

            @Override
            public void run(ExecutionService executionService) {
                executionService.notifyTaskStarted(Task.this);
                if (previousStatus == TaskStatus.PENDING || previousStatus == TaskStatus.PLANNED) {
                    executionService.labelLastRevisionAsUnstarted(Task.this);
                }
            }
        });
        return changes;
    }

    private Changes delayStartup() {
        Changes changes = new Changes();
        this.status = TaskStatus.PENDING;
        changes.update((ConfigurationItem)this, ReleaseActivities.TASK_DELAYED.create(this.getTitle(), ReleaseActivitiesFormatter.formatDate(this.getScheduledStartDate())));
        return changes;
    }

    public Changes markAsDone(String targetId, TaskStatus status) {
        this.checkOwnId(targetId);
        Preconditions.checkArgument((boolean)status.isOneOf(TaskStatus.COMPLETED, TaskStatus.SKIPPED), (Object)"status must be either COMPLETED or SKIPPED");
        this.setStatus(status);
        this.setEndDate(new Date());
        this.setFlagStatus(FlagStatus.OK);
        this.setFlagComment("");
        Changes changes = new Changes();
        this.freezeVariables(changes, true);
        if (status == TaskStatus.COMPLETED) {
            changes.update((ConfigurationItem)this, ReleaseActivities.TASK_COMPLETED.create(this.getTitle()));
        } else {
            changes.update((ConfigurationItem)this, ReleaseActivities.TASK_SKIPPED.create(this.getTitle()));
        }
        return changes;
    }

    public Changes fail(String targetId, String failReason) {
        this.checkOwnId(targetId);
        this.setStatus(TaskStatus.FAILED);
        this.setOwner(this.getReleaseOwner());
        Changes changes = new Changes();
        changes.update((ConfigurationItem)this, ReleaseActivities.TASK_FAILED.create(this.getTitle(), failReason));
        changes.addComment(this.getId(), failReason);
        return changes;
    }

    private void checkOwnId(String targetId) {
        Preconditions.checkArgument((boolean)this.getId().equals(targetId), (String)"tried to access subtask '%s' of leaf task '%s'", (Object[])new Object[]{targetId, this.getId()});
    }

    public Changes abort() {
        Changes changes = new Changes();
        if (!this.isDone()) {
            this.setStatus(TaskStatus.ABORTED);
            this.setEndDate(new Date());
            changes.update((ConfigurationItem)this);
        }
        return changes;
    }

    @Override
    public boolean isDone() {
        return this.status != null && this.status.isDone();
    }

    @Override
    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isAborted() {
        return this.status == TaskStatus.ABORTED;
    }

    public boolean isPlanned() {
        return this.status == null || this.status == TaskStatus.PLANNED;
    }

    public boolean isActive() {
        return this.status == null || this.status.isActive();
    }

    public boolean isStarted() {
        return this.status == TaskStatus.IN_PROGRESS;
    }

    public boolean isPending() {
        return this.status == TaskStatus.PENDING;
    }

    public boolean isFailed() {
        return this.status == TaskStatus.FAILED;
    }

    public boolean isFailing() {
        return this.status == TaskStatus.FAILING;
    }

    public boolean isAssignedTo(Team team) {
        return team.getTeamName().equals(this.getTeam());
    }

    public boolean isAssigned() {
        return this.getOwner() != null;
    }

    public boolean isGate() {
        return this instanceof GateTask;
    }

    public boolean isParallelGroup() {
        return this instanceof ParallelGroup;
    }

    public Changes resetToPlanned() {
        Changes changes = new Changes();
        this.status = TaskStatus.PLANNED;
        changes.update((ConfigurationItem)this);
        for (Comment comment : this.comments) {
            changes.remove(comment.getId());
        }
        this.comments.clear();
        return changes;
    }

    @Override
    public Release getRelease() {
        return this.getPhase() != null ? this.getPhase().getRelease() : null;
    }

    @Override
    public String getDisplayPath() {
        return this.getPhase().getDisplayPath() + " / " + this.getTitle();
    }

    public String getReleaseOwner() {
        return this.getPhase().getReleaseOwner();
    }

    @Override
    public List<Task> getAllTasks() {
        return Lists.newArrayList((Object[])new Task[]{this});
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
    }

    public Set<String> freezeVariables(Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        if (this.getPhase() == null || this.getPhase().getRelease() == null) {
            return unresolvedVariables;
        }
        HashMap variables = this.getPhase().getRelease().getVariableValues();
        if (variables == null) {
            variables = Maps.newHashMap();
        }
        changes.update((ConfigurationItem)this);
        this.setTitle(this.replaceAll(this.getTitle(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setDescription(this.replaceAll(this.getDescription(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setOwner(this.replaceAll(this.getOwner(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        unresolvedVariables.addAll(this.freezeVariablesInCustomFields(variables, changes, freezeEvenIfUnresolved));
        return unresolvedVariables;
    }

    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        return Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Task task = (Task)((Object)o);
        if (this.id != null ? !this.id.equals(task.id) : task.id != null) {
            return false;
        }
        return this.status == task.status;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }
}

