/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.email;

import com.xebialabs.xlrelease.email.EmailProvider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.search.LdapUserSearch;

class LdapEmailProvider
implements EmailProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapEmailProvider.class);
    private final LdapUserSearch userSearch;

    LdapEmailProvider(LdapAuthenticationProvider authProvider) throws Exception {
        BindAuthenticator authenticator = LdapEmailProvider.invokePrivateMethod(authProvider, LdapAuthenticationProvider.class, "getAuthenticator", BindAuthenticator.class);
        this.userSearch = LdapEmailProvider.invokePrivateMethod(authenticator, AbstractLdapAuthenticator.class, "getUserSearch", LdapUserSearch.class);
    }

    LdapEmailProvider(LdapUserSearch userSearch) {
        this.userSearch = userSearch;
    }

    @Override
    public String getEmail(String userName) {
        DirContextOperations data = this.getUserData(userName);
        return this.extractMail(userName, data);
    }

    private DirContextOperations getUserData(String userName) {
        try {
            return this.userSearch.searchForUser(userName);
        }
        catch (UsernameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Error accessing LDAP server", (Throwable)e);
            return null;
        }
    }

    private String extractMail(String userName, DirContextOperations data) {
        if (data == null) {
            return null;
        }
        if (!data.attributeExists("mail")) {
            LOGGER.warn("LDAP entry for user {} has no 'mail' field", (Object)userName);
        } else {
            try {
                return data.getStringAttribute("mail");
            }
            catch (ClassCastException e) {
                LOGGER.warn("'mail' field of LDAP entry for user {} should be a String", (Object)userName);
            }
        }
        return null;
    }

    private static <T, R> R invokePrivateMethod(Object target, Class<T> targetClass, String methodName, Class<R> returnType) throws Exception {
        Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return returnType.cast(method.invoke(target, new Object[0]));
    }
}

