/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notification;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.XLReleaseServerConfiguration;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notification.EmailSender;
import com.xebialabs.xlrelease.notification.Templater;
import com.xebialabs.xlrelease.repository.UserProfiles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Notifications {
    static final String PREFIX = "[XL Release] ";
    static final String TASK_ASSIGNED_TO_OWNER_SUBJECT = "[XL Release] Task assignment: ";
    static final String TASK_ASSIGNED_TO_OWNER_TEMPLATE = "task-assigned-to-owner.mustache";
    static final String TASK_PICKED_SUBJECT = "[XL Release] Task assignement: ";
    static final String TASK_PICKED_TEMPLATE = "task-picked.mustache";
    static final String TASK_FAILED_SUBJECT = "[XL Release] Task failed: ";
    static final String TASK_FAILED_TEMPLATE = "task-failed.mustache";
    static final String TASK_STARTED_SUBJECT = "[XL Release] Task started: ";
    static final String TASK_STARTED_TEMPLATE = "task-started.mustache";
    static final String UNASSIGNED_TASK_STARTED_SUBJECT = "[XL Release] Unassigned task started: ";
    static final String UNASSIGNED_TASK_STARTED_TEMPLATE = "task-started-unassigned.mustache";
    static final String TASK_COMMENT_ADDED_SUBJECT = "[XL Release] New comment on task: ";
    static final String TASK_COMMENT_ADDED_TEMPLATE = "task-comment-added.mustache";
    static final String RELEASE_FLAGGED_SUBJECT = "[XL Release] Release flagged: ";
    static final String RELEASE_FLAGGED_TEMPLATE = "release-flagged.mustache";
    static final String NOTIFICATION_TASK_BODY_TEMPLATE = "notification-task-body.mustache";
    private final UserProfiles userProfiles;
    private final Templater templater;
    private final EmailSender emailSender;
    private final XLReleaseServerConfiguration serverConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);

    @Autowired
    public Notifications(UserProfiles userProfiles, Templater templater, EmailSender emailSender, XLReleaseServerConfiguration serverConfiguration) {
        this.userProfiles = userProfiles;
        this.templater = templater;
        this.emailSender = emailSender;
        this.serverConfiguration = serverConfiguration;
    }

    public void notifyAssignedToOwner(Task task) {
        this.sendEmail(task.getOwner(), TASK_ASSIGNED_TO_OWNER_SUBJECT + task.getTitle(), TASK_ASSIGNED_TO_OWNER_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskPicked(Task task) {
        HashSet users = Sets.newHashSet();
        if (task.hasTeamCi()) {
            users.addAll(task.getTeamCi().getMembers());
        }
        users.remove(task.getOwner());
        this.sendEmail(users, TASK_PICKED_SUBJECT + task.getTitle(), TASK_PICKED_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskReassigned(Task task, String previousOwner) {
        ArrayList users = Lists.newArrayList((Object[])new String[]{previousOwner});
        this.sendEmail(users, TASK_PICKED_SUBJECT + task.getTitle(), TASK_PICKED_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskFailed(Release release, Task task) {
        this.sendEmail(release.getOwner(), TASK_FAILED_SUBJECT + task.getTitle(), TASK_FAILED_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskStarted(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        if (task.isAssigned()) {
            this.sendEmail(task.getOwner(), TASK_STARTED_SUBJECT + task.getTitle(), TASK_STARTED_TEMPLATE, this.taskContext(task));
        } else if (task.hasTeamCi()) {
            this.sendEmail(task.getTeamCi().getMembers(), TASK_STARTED_SUBJECT + task.getTitle(), TASK_STARTED_TEMPLATE, this.taskContext(task));
        } else if (!isAutomated) {
            Release release = task.getPhase().getRelease();
            this.sendEmail(release.getOwner(), UNASSIGNED_TASK_STARTED_SUBJECT + task.getTitle(), UNASSIGNED_TASK_STARTED_TEMPLATE, this.taskContext(task));
        }
    }

    public void notifyCommentAdded(Task task, Comment comment) {
        Release release = task.getPhase().getRelease();
        HashSet users = Sets.newHashSet((Object[])new String[]{release.getOwner(), task.getOwner()});
        if (task.hasTeamCi()) {
            users.addAll(task.getTeamCi().getMembers());
        }
        users.remove(comment.getAuthor());
        this.sendEmail(users, TASK_COMMENT_ADDED_SUBJECT + task.getTitle(), TASK_COMMENT_ADDED_TEMPLATE, this.commentContext(task, comment));
    }

    public void notifyReleaseFlagged(Release release, FlagStatus newStatus, String comment) {
        this.sendEmail(release.getOwner(), RELEASE_FLAGGED_SUBJECT + release.getTitle(), RELEASE_FLAGGED_TEMPLATE, this.releaseFlagContext(release, newStatus, comment));
    }

    public void executeNotificationTask(NotificationTask task, Runnable onSuccess, Runnable onException) {
        try {
            String bodyText = task.getBody();
            Map<String, Object> context = this.taskContext(task);
            context.put("body", bodyText);
            String body = this.templater.processTemplate(context, NOTIFICATION_TASK_BODY_TEMPLATE);
            this.emailSender.scheduleEmail(task.getAddresses(), task.getSubject(), body, onSuccess, onException);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendEmail(String user, String subject, String template, Map<String, Object> context) {
        this.sendEmail(Collections.singleton(user), subject, template, context);
    }

    private void sendEmail(Collection<String> users, String subject, String template, Map<String, Object> context) {
        ArrayList<String> recipients = new ArrayList<String>();
        for (String user : users) {
            String recipient = this.userProfiles.getNotificationEmail(user);
            if (recipient == null) {
                logger.warn("Email address not found for {}; not sending email with subject '{}' for task {}", new Object[]{user, subject, context.get("displayPath")});
                continue;
            }
            recipients.add(recipient);
        }
        if (recipients.isEmpty()) {
            return;
        }
        try {
            String body = this.templater.processTemplate(context, template);
            this.emailSender.scheduleEmail(recipients, subject, body);
        }
        catch (Exception e) {
            logger.error("Could not schedule email ", (Throwable)e);
        }
    }

    Map<String, Object> taskContext(Task task) {
        HashMap context = Maps.newHashMap();
        context.put("title", task.getTitle());
        context.put("displayPath", task.getDisplayPath());
        context.put("owner", task.getOwner());
        context.put("description", task.getDescription());
        context.put("release", task.getRelease().getTitle());
        context.put("releaseIsFailed", task.getRelease().isFailed());
        context.put("releaseIsFailing", task.getRelease().isFailing());
        context.put("url", this.serverConfiguration.getServerUrl());
        return context;
    }

    Map<String, Object> commentContext(Task task, Comment comment) {
        Map<String, Object> context = this.taskContext(task);
        context.put("commentAuthor", comment.getAuthor());
        context.put("commentText", comment.getText());
        return context;
    }

    Map<String, Object> releaseFlagContext(Release release, FlagStatus flagStatus, String comment) {
        HashMap context = Maps.newHashMap();
        context.put("displayPath", release.getDisplayPath());
        context.put("release", release.getTitle());
        context.put("flagStatus", flagStatus);
        context.put("flagComment", comment);
        context.put("url", this.serverConfiguration.getServerUrl());
        return context;
    }
}

