/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.reports.AverageByMonthComputer;
import com.xebialabs.xlrelease.reports.ReleaseAutomation;
import com.xebialabs.xlrelease.views.Point;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class ReleaseAutomationComputer {
    private List<ReleaseAutomation> releasesAutomation;
    private Map<String, List<Point>> dataSeries = Maps.newHashMap();
    private List<Point> automationPercentageSerie = Lists.newArrayList();
    private List<Point> automationDurationPercentageSerie = Lists.newArrayList();
    private AverageByMonthComputer averageAutomationComputer;
    private AverageByMonthComputer averageAutomationDurationComputer;

    public ReleaseAutomationComputer(List<ReleaseAutomation> releasesAutomation) {
        this.releasesAutomation = releasesAutomation;
        this.dataSeries.put(SerieTitle.AUTOMATION_PERCENTAGE.name(), this.automationPercentageSerie);
        this.dataSeries.put(SerieTitle.AUTOMATION_DURATION_PERCENTAGE.name(), this.automationDurationPercentageSerie);
        if (releasesAutomation.size() > 0) {
            DateTime startDate = releasesAutomation.get(0).getEndDate();
            this.averageAutomationComputer = new AverageByMonthComputer(startDate);
            this.averageAutomationDurationComputer = new AverageByMonthComputer(startDate);
        } else {
            this.dataSeries.put(SerieTitle.AVERAGE_AUTOMATION_PERCENTAGE.name(), Lists.newArrayList());
            this.dataSeries.put(SerieTitle.AVERAGE_AUTOMATION_DURATION_PERCENTAGE.name(), Lists.newArrayList());
        }
    }

    public Map<String, List<Point>> getSeries() {
        if (this.releasesAutomation.size() > 0) {
            for (ReleaseAutomation releaseAutomation : this.releasesAutomation) {
                float automationPercentage = this.computePercentage(releaseAutomation.getNumberOfAutomatedTasks(), releaseAutomation.getNumberOfTasks());
                float automationDurationPercentage = this.computePercentage(releaseAutomation.getAutomatedDuration(), releaseAutomation.getTotalDuration());
                this.automationPercentageSerie.add(new Point(releaseAutomation.getTitle(), releaseAutomation.getEndDate().getMillis(), automationPercentage));
                this.automationDurationPercentageSerie.add(new Point(releaseAutomation.getTitle(), releaseAutomation.getEndDate().getMillis(), automationDurationPercentage));
                this.averageAutomationComputer.add(releaseAutomation.getEndDate(), automationPercentage);
                this.averageAutomationDurationComputer.add(releaseAutomation.getEndDate(), automationDurationPercentage);
            }
            DateTime endDate = this.releasesAutomation.get(this.releasesAutomation.size() - 1).getEndDate();
            this.dataSeries.put(SerieTitle.AVERAGE_AUTOMATION_PERCENTAGE.name(), this.averageAutomationComputer.completeSerie(endDate));
            this.dataSeries.put(SerieTitle.AVERAGE_AUTOMATION_DURATION_PERCENTAGE.name(), this.averageAutomationDurationComputer.completeSerie(endDate));
        }
        return this.dataSeries;
    }

    private float computePercentage(float number, float total) {
        return number / total * 100.0f;
    }

    public static enum SerieTitle {
        AUTOMATION_PERCENTAGE,
        AUTOMATION_DURATION_PERCENTAGE,
        AVERAGE_AUTOMATION_PERCENTAGE,
        AVERAGE_AUTOMATION_DURATION_PERCENTAGE;

    }
}

