/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.builder.CommentBuilder;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notification.Notifications;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Comments
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(Comments.class);
    private ActivityLog activityLog;
    private Notifications notifications;

    @Autowired
    public Comments(RepositoryService repositoryService, ActivityLog activityLog, Notifications notifications) {
        super(repositoryService);
        this.activityLog = activityLog;
        this.notifications = notifications;
    }

    @Override
    protected String getEntityPrefix() {
        return "Comment";
    }

    public Comment create(String taskId, String text, User author, boolean notify) {
        Task task = (Task)this.repositoryService.read(taskId);
        if (task instanceof ParallelGroup) {
            throw new IllegalArgumentException("cannot comment on parallel groups");
        }
        Comment comment = CommentBuilder.newComment().withId(this.getUniqueId(taskId)).withText(text).withAuthor(author.getName()).withDate(new Date()).build();
        this.repositoryService.create((ConfigurationItem[])new Comment[]{comment});
        this.activityLog.log(Ids.releaseIdFrom(taskId), ReleaseActivities.COMMENT_ADDED.create(text, task.getTitle()));
        if (notify) {
            this.notifications.notifyCommentAdded(task, comment);
        }
        logger.debug("Creating comment: {}", (Object)comment);
        return comment;
    }

    public Comment update(String commentId, String text) {
        Comment comment = (Comment)this.repositoryService.read(commentId);
        String originalText = comment.getText();
        comment.setText(text);
        comment.setDate(new Date());
        this.repositoryService.update((ConfigurationItem[])new Comment[]{comment});
        String taskId = Ids.getParentId(commentId);
        Task task = (Task)this.repositoryService.read(taskId);
        this.activityLog.log(Ids.releaseIdFrom(taskId), ReleaseActivities.COMMENT_UPDATED.create(originalText, text, task.getTitle()));
        return comment;
    }
}

