/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.activity.GateConditionsFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GateConditions
extends AbstractRepository {
    private static final String DEFAULT_TITLE = "New Condition";
    private ActivityLog activityLog;

    @Autowired
    public GateConditions(RepositoryService repositoryService, ActivityLog activityLog) {
        super(repositoryService);
        this.activityLog = activityLog;
    }

    @Override
    protected String getEntityPrefix() {
        return "Condition";
    }

    public GateCondition create(String parentId) {
        return this.create(parentId, DEFAULT_TITLE);
    }

    public GateCondition create(String gateId, String text) {
        Task gate = (Task)this.repositoryService.read(gateId);
        Preconditions.checkArgument((!gate.isDefunct() ? 1 : 0) != 0, (Object)"Can't add condition on defunct gate");
        GateCondition condition = new GateCondition();
        condition.setId(this.getUniqueId(gateId));
        condition.setTitle(text);
        this.repositoryService.create((ConfigurationItem[])new GateCondition[]{condition});
        this.activityLog.log(Ids.releaseIdFrom(gateId), ReleaseActivities.GATE_CONDITION_CREATED.create(condition.getTitle(), gate.getTitle()));
        return condition;
    }

    public GateCondition findById(String conditionId) {
        return (GateCondition)this.repositoryService.read(conditionId);
    }

    public GateCondition update(String conditionId, GateCondition updatedCondition) {
        String gateId = Ids.getParentId(updatedCondition.getId());
        GateTask gate = (GateTask)this.repositoryService.read(gateId);
        Preconditions.checkArgument((!gate.isDefunct() ? 1 : 0) != 0, (Object)"Can't update condition of a defunct gate");
        GateCondition condition = (GateCondition)this.repositoryService.read(conditionId);
        List<ActivityLogEntry> logs = new GateConditionsFieldsComparator(gate, condition, updatedCondition).getLogs();
        condition.setChecked(updatedCondition.isChecked());
        condition.setTitle(updatedCondition.getTitle());
        this.repositoryService.update((ConfigurationItem[])new GateCondition[]{condition});
        this.activityLog.log(Ids.releaseIdFrom(gateId), logs, User.AUTHENTICATED_USER);
        return updatedCondition;
    }

    public void delete(String conditionId) {
        String gateId = Ids.getParentId(conditionId);
        Task gate = (Task)this.repositoryService.read(gateId);
        Preconditions.checkArgument((!gate.isDefunct() ? 1 : 0) != 0, (Object)"Can't delete condition of a defunct gate");
        GateCondition gateCondition = (GateCondition)this.repositoryService.read(conditionId);
        this.repositoryService.delete(new String[]{conditionId});
        this.activityLog.log(Ids.releaseIdFrom(gateId), ReleaseActivities.GATE_CONDITION_DELETED.create(gateCondition.getTitle(), gate.getTitle()));
    }
}

