/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.xlrelease.repository.JcrPredicate;

public class JcrQueryBuilder {
    private StringBuilder query = new StringBuilder();

    private JcrQueryBuilder(String ... selectedFields) {
        this.query.append("SELECT ");
        this.query.append(selectedFields[0]);
        for (int i = 1; i < selectedFields.length; ++i) {
            this.query.append(", ").append(selectedFields[i]);
        }
    }

    public static JcrQueryBuilder select(String ... fields) {
        return new JcrQueryBuilder(fields);
    }

    public JcrQueryBuilder selectTypeAs(String selector, String alias) {
        this.query.append(", ").append(selector).append(".[").append("$configuration.item.type");
        this.query.append("] AS ").append(alias);
        return this;
    }

    public JcrQueryBuilder from(String selector) {
        this.query.append(" FROM [");
        this.query.append("deployit:configurationItem");
        this.query.append("] AS ");
        this.query.append(selector);
        return this;
    }

    public JcrQueryBuilder joinWithParent(String childSelector, String parentSelector) {
        this.query.append(" INNER JOIN [");
        this.query.append("deployit:configurationItem");
        this.query.append("] AS ");
        this.query.append(parentSelector);
        this.query.append(" ON ");
        this.query.append(JcrPredicate.isDescendantNode(childSelector, parentSelector));
        return this;
    }

    public JcrQueryBuilder where(String predicate) {
        this.query.append(" WHERE ");
        this.query.append(predicate);
        return this;
    }

    public JcrQueryBuilder orderBy(String expression) {
        this.query.append(" ORDER BY ");
        this.query.append(expression);
        return this;
    }

    public String toString() {
        return this.query.toString();
    }
}

