/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Releases
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(Releases.class);
    protected static final String ROOT = "Applications";
    protected static final String RELEASE_PREFIX = "Release";
    private ActivityLog activityLog;

    @Autowired
    public Releases(RepositoryService repositoryService, ActivityLog activityLog) {
        super(repositoryService);
        this.activityLog = activityLog;
    }

    @Override
    protected String getEntityPrefix() {
        return RELEASE_PREFIX;
    }

    public Release createWithoutTemplate(Release release) {
        String releaseId = this.getUniqueId(ROOT);
        release.setId(releaseId);
        release.setStatus(ReleaseStatus.PLANNED);
        this.initReleaseCalendar(release);
        logger.info("Creating empty release " + releaseId);
        this.repositoryService.create((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(releaseId, ReleaseActivities.RELEASE_CREATED.create(release.getTitle()));
        return (Release)this.repositoryService.read(releaseId);
    }

    public Release createFromTemplate(String templateId, Release releaseMetadata) {
        String releaseId = this.getUniqueId(ROOT);
        Release template = (Release)this.repositoryService.read(templateId);
        logger.info("Creating new release " + releaseId + " from template " + templateId);
        this.repositoryService.copy(templateId, releaseId);
        Release release = this.fillReleaseWithMetadata(releaseId, releaseMetadata);
        this.activityLog.delete(release.getActivityLogEntries());
        this.activityLog.log(releaseId, ReleaseActivities.RELEASE_CREATED_FROM_TEMPLATE.create(release.getTitle(), template.getTitle()));
        return release;
    }

    public Release createTemplate(String title, String description, List<String> tags) {
        Release template = ReleaseBuilder.newRelease().withId(this.getUniqueId(ROOT)).withTitle(title).withDescription(description).withStatus(ReleaseStatus.TEMPLATE).withTags(tags).build();
        this.repositoryService.create((ConfigurationItem[])new Release[]{template});
        this.activityLog.log(template.getId(), ReleaseActivities.TEMPLATE_CREATED.create(new Object[0]));
        return template;
    }

    public Release copyTemplate(String templateId, String title, String description) {
        String newTemplateId = this.getUniqueId(ROOT);
        this.repositoryService.copy(templateId, newTemplateId);
        Release template = (Release)this.repositoryService.read(newTemplateId);
        template.setTitle(title);
        template.setDescription(description);
        this.repositoryService.update((ConfigurationItem[])new Release[]{template});
        this.activityLog.log(newTemplateId, ReleaseActivities.TEMPLATE_DUPLICATED.create(template.getTitle()));
        return template;
    }

    private Release fillReleaseWithMetadata(String releaseId, Release releaseMetadata) {
        Release newRelease = (Release)this.repositoryService.read(releaseId);
        newRelease.setStatus(ReleaseStatus.PLANNED);
        newRelease.setDescription(releaseMetadata.getDescription());
        newRelease.setTitle(releaseMetadata.getTitle());
        newRelease.setScheduledStartDate(releaseMetadata.getScheduledStartDate());
        newRelease.setDueDate(releaseMetadata.getDueDate());
        newRelease.setOwner(releaseMetadata.hasOwner() ? releaseMetadata.getOwner() : Permissions.getAuthenticatedUserName());
        newRelease.addVariableValues(releaseMetadata.getVariableValues());
        newRelease.setTags(releaseMetadata.getTags());
        newRelease.setFlagStatus(releaseMetadata.getFlagStatus());
        newRelease.setFlagComment(releaseMetadata.getFlagComment());
        this.initReleaseCalendar(newRelease);
        this.repositoryService.update((ConfigurationItem[])new Release[]{newRelease});
        return newRelease;
    }

    private void initReleaseCalendar(Release newRelease) {
        Long token = UUID.randomUUID().getMostSignificantBits();
        newRelease.setCalendarLinkToken(token.toString());
        newRelease.setCalendarPublished(false);
    }

    public List<Release> findAll(boolean planned, boolean inProgress, boolean completed, boolean onlyMyRelease, boolean onlyFlagged, String searchFilter) {
        ArrayList statuses = Lists.newArrayList();
        if (planned) {
            statuses.add(ReleaseStatus.PLANNED.name());
        }
        if (inProgress) {
            statuses.add(ReleaseStatus.IN_PROGRESS.name());
            statuses.add(ReleaseStatus.FAILED.name());
            statuses.add(ReleaseStatus.FAILING.name());
            statuses.add(ReleaseStatus.PAUSED.name());
        }
        if (completed) {
            statuses.add(ReleaseStatus.COMPLETED.name());
            statuses.add(ReleaseStatus.ABORTED.name());
        }
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class));
        if (!statuses.isEmpty()) {
            String statusClause = Joiner.on((String)" OR ").join((Iterable)statuses);
            query.addTextSearch("status", statusClause);
        }
        if (onlyMyRelease) {
            query.addProperty("owner", Permissions.getAuthenticatedUserName());
        }
        if (statuses.isEmpty() && !onlyMyRelease) {
            return Lists.newArrayList();
        }
        List releases = this.repositoryService.listEntities(query);
        return new ReleaseFilter(searchFilter, onlyFlagged).filter(releases);
    }

    public List<Release> active() {
        return this.withStatus(ReleaseStatus.activeStatuses());
    }

    public List<Release> withStatus(ReleaseStatus ... statuses) {
        ArrayList statusNames = Lists.newArrayList();
        for (ReleaseStatus status : statuses) {
            statusNames.add(status.name());
        }
        String statusClause = Joiner.on((String)" OR ").join((Iterable)statusNames);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class)).addTextSearch("status", statusClause);
        return this.repositoryService.listEntities(query);
    }

    public Release containingTask(String taskId) {
        return (Release)this.repositoryService.read(Ids.releaseIdFrom(taskId));
    }

    public Release containingTeam(String teamId) {
        return (Release)this.repositoryService.read(Ids.releaseIdFrom(teamId));
    }

    public Release findById(String releaseId) {
        return (Release)this.repositoryService.read(releaseId);
    }

    public Map<String, Collection<String>> getMyGrantedPermissions() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setType(Type.valueOf(Release.class));
        List releases = this.repositoryService.listEntities(searchParameters);
        HashMap permissionsByRelease = Maps.newHashMap();
        for (Release release : releases) {
            Set<String> permissions = release.getPermissions(Permissions.getAuthenticatedUserName());
            if (permissions.isEmpty()) continue;
            permissionsByRelease.put(release.getId(), permissions);
        }
        return permissionsByRelease;
    }

    public Release findByCalendarToken(String calendarToken) {
        SearchParameters query = new SearchParameters().addProperty("calendarLinkToken", calendarToken);
        List releases = this.repositoryService.listEntities(query);
        if (releases == null || releases.isEmpty()) {
            return null;
        }
        return (Release)((Object)releases.get(0));
    }
}

