/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.JcrHistoryService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Tasks
extends AbstractRepository {
    static final String UNSTARTED_REVISION = "UNSTARTED_REVISION";
    private ActivityLog activityLog;
    private JcrHistoryService historyService;
    private static final Logger logger = LoggerFactory.getLogger(Tasks.class);

    @Autowired
    public Tasks(RepositoryService repositoryService, ActivityLog activityLog, JcrHistoryService historyService) {
        super(repositoryService);
        this.activityLog = activityLog;
        this.historyService = historyService;
    }

    @Override
    protected String getEntityPrefix() {
        return "Task";
    }

    public Task findById(String taskId) {
        return (Task)this.repositoryService.read(taskId);
    }

    public List<Task> findById(List<String> taskIds) {
        ArrayList tasks = Lists.newArrayList();
        for (String taskId : taskIds) {
            tasks.add((Task)this.repositoryService.read(taskId));
        }
        return tasks;
    }

    public List<GateTask> findActiveGates() {
        return this.findGatesWithStatus(TaskStatus.IN_PROGRESS);
    }

    public List<GateTask> findGatesWithStatus(TaskStatus ... statuses) {
        ArrayList statusNames = Lists.newArrayList();
        for (TaskStatus status : statuses) {
            statusNames.add(status.name());
        }
        String statusClause = Joiner.on((String)" OR ").join((Iterable)statusNames);
        List gates = this.repositoryService.listEntities(new SearchParameters().setType(Type.valueOf(GateTask.class)).addTextSearch("status", statusClause));
        Iterable releaseGates = Iterables.filter((Iterable)gates, Task.DOES_NOT_BELONG_TO_TEMPLATE);
        return Lists.newArrayList((Iterable)releaseGates);
    }

    public List<Task> findPendingTasks() {
        return this.repositoryService.listEntities(new SearchParameters().setType(Type.valueOf(Task.class)).addTextSearch("status", TaskStatus.PENDING.value()));
    }

    public void updateTaskWith(Task task, TaskFullView updatedTask) {
        Preconditions.checkArgument((!task.isDefunct() ? 1 : 0) != 0, (Object)"Can't update defunct task");
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(task, updatedTask), (Object)"Can't update scheduled start date of a task that is neither planned or pending");
        Preconditions.checkArgument((boolean)this.isFlagStatusUpdatable(task, updatedTask), (Object)"Can't update flag status or comment of a task in a release template");
        List<ActivityLogEntry> logEntries = new TaskFieldsComparator(task, updatedTask).getLogs();
        task.setTitle(updatedTask.getTitle());
        task.setDescription(updatedTask.getDescription());
        task.setDueDate(updatedTask.getDueDate());
        task.setFlagStatus(updatedTask.getFlag().getStatus());
        task.setFlagComment(updatedTask.getFlag().getComment());
        task.setScheduledStartDate(updatedTask.getScheduledStartDate());
        task.setTeam(updatedTask.getTeam());
        task.setOwner(updatedTask.getOwner());
        if (task instanceof DeployitTask) {
            DeployitTask deployitTask = (DeployitTask)task;
            deployitTask.setDeploymentPackage(updatedTask.getDeploymentPackage());
            deployitTask.setEnvironment(updatedTask.getEnvironment());
            deployitTask.setServer(updatedTask.getServer());
            deployitTask.setUsername(updatedTask.getUsername());
            deployitTask.setPassword(updatedTask.getPassword());
        } else if (task instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task;
            notificationTask.setAddresses(updatedTask.getAddresses());
            notificationTask.setSubject(updatedTask.getSubject());
            notificationTask.setBody(updatedTask.getBody());
        } else if (task instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task;
            scriptTask.setScript(updatedTask.getScript());
        } else if (task instanceof CustomScriptTask) {
            String name;
            CustomScriptTask customScriptTask = (CustomScriptTask)task;
            PythonScript pythonScript = customScriptTask.getPythonScript();
            for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
                name = propertyDescriptor.getName();
                customScriptTask.getPythonScript().setProperty(propertyDescriptor.getName(), updatedTask.getInputProperties().get(name));
            }
            for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
                name = propertyDescriptor.getName();
                String variableName = this.formatVariableIfNeeded(updatedTask.getOutputProperties().get(name));
                customScriptTask.getPythonScript().setProperty(propertyDescriptor.getName(), variableName);
            }
        }
        this.update(task);
        this.activityLog.log(Ids.releaseIdFrom(task.getId()), logEntries, User.AUTHENTICATED_USER);
    }

    private String formatVariableIfNeeded(String variableName) {
        if (!Strings.isNullOrEmpty((String)variableName) && !Variable.containOnlyVariable(variableName)) {
            variableName = "${" + variableName + "}";
        }
        return variableName;
    }

    private void update(Task task) {
        if (task instanceof CustomScriptTask) {
            this.repositoryService.update((ConfigurationItem[])new BaseConfigurationItem[]{task, ((CustomScriptTask)task).getPythonScript()});
        } else {
            this.repositoryService.update((ConfigurationItem[])new Task[]{task});
        }
    }

    private boolean isFlagStatusUpdatable(Task task, TaskFullView updatedTask) {
        return task.getRelease() == null || !task.getRelease().isTemplate() || Objects.equal((Object)((Object)task.getFlagStatus()), (Object)((Object)updatedTask.getFlag().getStatus())) && Objects.equal((Object)task.getFlagComment(), (Object)updatedTask.getFlag().getComment());
    }

    private boolean isScheduledStartDateUpdatable(Task task, TaskFullView updatedTask) {
        return task.isPlanned() || task.isPending() || Objects.equal((Object)task.getScheduledStartDate(), (Object)updatedTask.getScheduledStartDate());
    }

    public Task create(String containerId, Task task) {
        if (Ids.isPhaseId(containerId)) {
            this.checkPhaseConditionsForAdding(containerId);
        } else {
            this.checkParallelGroupConditionsForAdding(containerId);
        }
        return this.createTask(task, containerId);
    }

    private void checkPhaseConditionsForAdding(String containerId) {
        Phase phase = (Phase)this.repositoryService.read(containerId);
        Preconditions.checkArgument((!phase.isDefunct() ? 1 : 0) != 0, (Object)"Can't add task to defunct phase");
    }

    private void checkParallelGroupConditionsForAdding(String containerId) {
        ParallelGroup group = (ParallelGroup)this.repositoryService.read(containerId);
        Preconditions.checkArgument((boolean)group.getStatus().isOneOf(TaskStatus.PLANNED, TaskStatus.PENDING), (Object)"Can't add task to an in_progress, completed, failed, or aborted group");
    }

    private Task createTask(Task task, String containerId) {
        String taskType;
        String id = this.getUniqueId(containerId);
        task.setId(id);
        task.setStatus(TaskStatus.PLANNED);
        if (task instanceof CustomScriptTask) {
            PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
            pythonScript.setId(task.getId() + "/" + "PythonScript");
            this.repositoryService.create((ConfigurationItem[])new BaseConfigurationItem[]{task, pythonScript});
            taskType = pythonScript.getType().toString();
        } else {
            this.repositoryService.create((ConfigurationItem[])new Task[]{task});
            taskType = task.getType().toString();
        }
        Task createdTask = this.findById(task.getId());
        this.activityLog.log(Ids.releaseIdFrom(createdTask.getId()), ReleaseActivities.TASK_CREATED.create(task.getTitle(), taskType));
        return createdTask;
    }

    public void delete(String taskId) {
        Task task = (Task)this.repositoryService.read(taskId);
        Preconditions.checkArgument((boolean)task.isPlanned(), (Object)"Only planned tasks can be deleted");
        this.repositoryService.delete(new String[]{taskId});
        this.activityLog.log(Ids.releaseIdFrom(task.getId()), ReleaseActivities.TASK_DELETED.create(task.getTitle()));
    }

    public void labelLastRevisionAsUnstarted(String taskId) {
        List revisions = this.historyService.getVersionRevisions(taskId);
        if (revisions.size() < 2) {
            logger.warn("Attempted to label task '{}' which doesn't have any history", (Object)taskId);
            return;
        }
        this.historyService.labelRevision(taskId, ((ConfigurationItemRevision)revisions.get(revisions.size() - 2)).getRevisionId(), UNSTARTED_REVISION);
    }

    public Task findUnstartedRevision(String taskId) {
        try {
            return (Task)this.historyService.readRevisionByLabel(taskId, UNSTARTED_REVISION);
        }
        catch (JcrHistoryService.UnknownLabelException e) {
            logger.warn("Un-started revision label not found on task '{}'", (Object)taskId);
            return null;
        }
    }
}

