/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.security.provider.PolicyFile;

@Service
public class ScriptService {
    public static final String SCRIPT_POLICY_FILE = "script.policy";
    private static final Logger logger = LoggerFactory.getLogger(ScriptService.class);
    private Scheduler scheduler;
    private ActivityLog activityLog;
    private RepositoryService repositoryService;

    @Autowired
    public ScriptService(Scheduler scheduler, ActivityLog activityLog, RepositoryService repositoryService) {
        this.scheduler = scheduler;
        this.activityLog = activityLog;
        this.repositoryService = repositoryService;
    }

    public void executeScriptTask(final ScriptTask task, final ScriptCallback onSuccess, final ScriptCallback onFailure) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                StringWriter executionLog = new StringWriter();
                ScriptContext scriptContext = ScriptService.this.makeScriptContext(executionLog);
                scriptContext.setAttribute("release", (Object)task.getRelease(), 100);
                scriptContext.setAttribute("phase", (Object)task.getPhase(), 100);
                scriptContext.setAttribute("task", (Object)task, 100);
                try {
                    ScriptService.this.executeScript(task.getScript(), scriptContext);
                    ScriptService.this.completeTask(executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    ScriptService.this.onScriptException(exception, executionLog, onFailure, task.getId());
                }
                catch (Throwable exception) {
                    ScriptService.this.onException(exception, executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of script task '{}':");
                }
            }
        });
    }

    public void executeCustomScriptTask(final CustomScriptTask task, final ScriptCallback onSuccess, final ScriptCallback onFailure) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                String script;
                StringWriter executionLog = new StringWriter();
                try {
                    script = task.getPythonScript().getScript();
                }
                catch (IOException exception) {
                    ScriptService.this.onException(exception, executionLog, onFailure, task.getId(), "Exception while loading script:\n", "Error while loading script on task '{}':");
                    return;
                }
                ScriptContext scriptContext = ScriptService.this.makeCustomScriptContext(executionLog, task);
                try {
                    ScriptService.this.executeScript(script, scriptContext);
                    ScriptService.this.saveCustomScriptResults(task.getId(), scriptContext);
                    ScriptService.this.completeTask(executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    ScriptService.this.onScriptException(exception, executionLog, onFailure, task.getId());
                }
                catch (Throwable exception) {
                    ScriptService.this.onException(exception, executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of script task '{}':");
                }
            }
        });
    }

    private ScriptContext makeScriptContext(Writer output) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setWriter(output);
        return context;
    }

    private ScriptContext makeCustomScriptContext(StringWriter executionLog, CustomScriptTask task) {
        ScriptContext scriptContext = this.makeScriptContext(executionLog);
        for (PropertyDescriptor propertyDescriptor : task.getPythonScript().getInputProperties()) {
            String propertyName = propertyDescriptor.getName();
            scriptContext.setAttribute(propertyName, task.getPythonScript().getProperty(propertyName), 100);
        }
        return scriptContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCustomScriptResults(String taskId, ScriptContext scriptContext) {
        Object object = ReleaseLock.of(taskId);
        synchronized (object) {
            CustomScriptTask task = (CustomScriptTask)this.repositoryService.read(taskId);
            Release release = task.getRelease();
            Collection<PropertyDescriptor> outputProperties = task.getPythonScript().getOutputProperties();
            Map<String, String> releaseVariables = release.getVariableValues();
            for (PropertyDescriptor propertyDescriptor : outputProperties) {
                String propertyName = propertyDescriptor.getName();
                String value = scriptContext.getAttribute(propertyName).toString();
                String variableName = (String)task.getPythonScript().getProperty(propertyName);
                releaseVariables.put(variableName, value);
                task.getPythonScript().setProperty(propertyName, value);
                this.activityLog.log(Ids.releaseIdFrom(taskId), ReleaseActivities.RELEASE_VARIABLE_UPDATED.create(variableName, value));
            }
            if (!outputProperties.isEmpty()) {
                this.repositoryService.update((ConfigurationItem[])new BaseConfigurationItem[]{release, task, task.getPythonScript()});
            }
        }
    }

    private void executeScript(String script, ScriptContext scriptContext) throws Throwable {
        PermissionCollection permissions = this.getScriptPermissions();
        ScriptExecutor executor = new ScriptExecutor(scriptContext, permissions);
        executor.evalScript(script);
    }

    private PermissionCollection getScriptPermissions() {
        PolicyFile scriptPolicy = new PolicyFile(ClassLoader.getSystemClassLoader().getResource(SCRIPT_POLICY_FILE));
        return scriptPolicy.getPermissions(new ProtectionDomain(new CodeSource(null, (Certificate[])null), null));
    }

    private void completeTask(StringWriter executionLog, ScriptCallback onSuccess, String taskId) {
        try {
            onSuccess.setExecutionLog(executionLog.toString());
            onSuccess.run();
        }
        catch (Exception exception) {
            logger.info("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
    }

    private void onScriptException(ScriptException exception, StringWriter executionLog, ScriptCallback onFailure, String taskId) {
        try {
            executionLog.append("Exception during execution:\n");
            executionLog.append(exception.getMessage());
            onFailure.setExecutionLog(executionLog.toString());
            onFailure.run();
        }
        catch (Exception e) {
            logger.info("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
    }

    private void onException(Throwable exception, StringWriter executionLog, ScriptCallback onFailure, String taskId, String executionLogMessage, String logMessage) {
        logger.error(logMessage, (Object)taskId, (Object)exception);
        executionLog.append(executionLogMessage);
        executionLog.append(exception.toString());
        onFailure.setExecutionLog(executionLog.toString());
        onFailure.run();
    }
}

