/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionChecker {
    private PermissionEnforcer permissionEnforcer;
    private Releases releases;
    private Tasks tasks;

    @Autowired
    public PermissionChecker(PermissionEnforcer permissionEnforcer, Releases releases, Tasks tasks) {
        this.permissionEnforcer = permissionEnforcer;
        this.releases = releases;
        this.tasks = tasks;
    }

    public void check(Permission permission) {
        if (!this.hasGlobalPermission(permission)) {
            String configurationItemId = null;
            throw PermissionDeniedException.forPermission((Permission)permission, configurationItemId);
        }
    }

    public void check(Permission permission, String releaseId) {
        if (!this.hasPermission(permission, releaseId)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)releaseId);
        }
    }

    public void check(Permission permission, List<String> releaseIds) {
        for (String configurationItemId : releaseIds) {
            this.check(permission, configurationItemId);
        }
    }

    public boolean hasPermission(Permission permission, String releaseId) {
        Release release = this.releases.findById(releaseId);
        return this.hasGlobalPermission(permission) || release.hasPermission(Permissions.getAuthenticatedUserName(), permission);
    }

    public boolean hasGlobalPermission(Permission permission) {
        return this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{permission});
    }

    public void checkView(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.VIEW_TEMPLATE : XLReleasePermissions.VIEW_RELEASE;
        this.check(permissionToCheck, releaseId);
    }

    public void checkEdit(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE;
        this.check(permissionToCheck, releaseId);
    }

    public void checkEditTask(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    public void checkReassignTask(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.REASSIGN_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    public void checkIsReleaseOwner(String releaseId) {
        Release release = this.releases.findById(releaseId);
        if (!this.hasGlobalPermission(PlatformPermissions.ADMIN) && !release.hasOwner(Permissions.getAuthenticatedUserName())) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)releaseId, (String)"Release owner");
        }
    }

    public void checkIsAllowedToWorkOnTask(String taskId) {
        Task task = this.tasks.findById(taskId);
        if (!(this.hasGlobalPermission(PlatformPermissions.ADMIN) || this.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(taskId)) || task.hasOwner(Permissions.getAuthenticatedUserName()))) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Task owner' or 'edit task'");
        }
    }

    public List<Release> filter(List<Release> items, final Permission permission) {
        Predicate<Release> isGranted = new Predicate<Release>(){

            public boolean apply(Release candidate) {
                return PermissionChecker.this.hasPermission(permission, candidate.getId());
            }
        };
        return Lists.newArrayList((Iterable)Collections2.filter(items, (Predicate)isGranted));
    }

    public void checkIsAllowedToCreateReleaseFromTemplate(String templateId) {
        Release template = this.releases.findById(templateId);
        if (!(this.hasGlobalPermission(PlatformPermissions.ADMIN) || template.hasPermission(Permissions.getAuthenticatedUserName(), XLReleasePermissions.VIEW_TEMPLATE) && (this.hasGlobalPermission(XLReleasePermissions.CREATE_RELEASE) || template.hasPermission(Permissions.getAuthenticatedUserName(), XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE)))) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)templateId, (String)"'View template' and ('Create release' or 'Create release from template')");
        }
    }
}

