/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plumbing.remote.DeployitConnection;
import com.xebialabs.deployit.plumbing.remote.DeployitConnectionFactory;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.repository.DeployitServers;
import com.xebialabs.xlrelease.repository.Ids;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeploymentService {
    private static final int DEPLOYIT_POLLING_INTERVAL_IN_SECONDS = 2;
    private static final int FAILED_CONNECTION_RETRY_INTERVAL_IN_SECONDS = 60;
    private DeployitServers servers;
    private RepositoryService repositoryService;
    private DeployitConnectionFactory connections;
    private Scheduler scheduler;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(DeployitServers servers, RepositoryService repositoryService, DeployitConnectionFactory connections, Scheduler scheduler) {
        this.servers = servers;
        this.repositoryService = repositoryService;
        this.connections = connections;
        this.scheduler = scheduler;
    }

    public void deployAsynchronously(final DeployitTask task, final Runnable onSuccess, final Runnable onFailure, final Runnable onException) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                String deployitTaskId;
                DeployitServerDefinition deployitServer;
                DeployitConnection deployit = null;
                try {
                    DeploymentService.this.ensureDeployitPropertiesFilled(task);
                    deployitServer = DeploymentService.this.servers.findById(task.getServer());
                    if (task.getDeployitTaskId() == null) {
                        BooterConfig booterConfig = DeploymentService.this.getBooterConfig(task, deployitServer);
                        deployit = DeploymentService.this.connections.connect(booterConfig);
                        deployitTaskId = DeploymentService.this.prepareOrResumeDeployment(task, deployit);
                    } else {
                        deployitTaskId = task.getDeployitTaskId();
                    }
                }
                catch (Exception e) {
                    DeploymentService.this.handleException(deployit, onException, "Deployment of task: '{}' failed.", new Object[]{task.getId(), e});
                    return;
                }
                PollProcess pollProcess = new PollProcess(task, deployit, deployitServer, deployitTaskId, true, onSuccess, onFailure);
                pollProcess.start();
            }
        });
    }

    public void rollbackAsynchronously(final String taskId) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                String rollbackTaskId;
                DeployitServerDefinition deployitServer;
                DeployitTask task;
                DeployitConnection deployit = null;
                try {
                    task = (DeployitTask)DeploymentService.this.repositoryService.read(taskId);
                    logger.info("Rolling back task: {}. Deployit task: {}", (Object)task.getId(), (Object)task.getDeployitTaskId());
                    deployitServer = DeploymentService.this.servers.findById(task.getServer());
                    deployit = DeploymentService.this.connections.connect(deployitServer.getBooterConfig());
                    rollbackTaskId = deployit.getDeploymentService().rollback(task.getDeployitTaskId());
                }
                catch (Exception e) {
                    DeploymentService.this.handleException(deployit, null, "Rolling back of task: '{}' failed.", new Object[]{taskId, e});
                    return;
                }
                RollbackResultHandler onRollbackSuccess = new RollbackResultHandler("Rolling back of task: '" + taskId + "' deployit task: '" + rollbackTaskId + "' succeeded.");
                RollbackResultHandler onRollbackFailure = new RollbackResultHandler("Rolling back of task: '" + taskId + "' deployit task: '" + rollbackTaskId + "' succeeded.");
                PollProcess pollProcess = new PollProcess(task, deployit, deployitServer, rollbackTaskId, false, onRollbackSuccess, onRollbackFailure);
                pollProcess.start();
            }
        });
    }

    private void ensureDeployitPropertiesFilled(DeployitTask task) {
        if (Strings.isNullOrEmpty((String)task.getServer()) || Strings.isNullOrEmpty((String)task.getDeploymentPackage()) || Strings.isNullOrEmpty((String)task.getEnvironment())) {
            throw new Checks.MissingArgumentException("Missing deployit data on task");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prepareOrResumeDeployment(DeployitTask taskDefinition, DeployitConnection deployit) {
        Deployment deployment;
        if (taskDefinition.getDeployitTaskId() != null) {
            return taskDefinition.getDeployitTaskId();
        }
        String environmentId = Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName() + "/" + taskDefinition.getEnvironment();
        String packageId = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName() + "/" + taskDefinition.getDeploymentPackage();
        String applicationName = DeploymentService.getApplicationName(taskDefinition.getDeploymentPackage());
        List deployedApplications = deployit.getRepositoryService().query(Type.valueOf(DeployedApplication.class), environmentId, applicationName, null, null, -1L, -1L);
        if (deployedApplications.isEmpty()) {
            deployment = deployit.getDeploymentService().prepareInitial(packageId, environmentId);
            deployment = deployit.getDeploymentService().generateAllDeployeds(deployment);
        } else {
            deployment = deployit.getDeploymentService().prepareUpdate(packageId, environmentId + "/" + applicationName);
        }
        String deployitTaskId = deployit.getDeploymentService().createTask(deployment);
        Object object = ReleaseLock.of(taskDefinition.getId());
        synchronized (object) {
            DeployitTask task = (DeployitTask)this.repositoryService.read(taskDefinition.getId());
            task.setDeployitTaskId(deployitTaskId);
            this.repositoryService.update((ConfigurationItem[])new DeployitTask[]{task});
        }
        return deployitTaskId;
    }

    private static String getApplicationName(String packageId) {
        return Ids.getName(Ids.getParentId(packageId));
    }

    private void startTaskIfInactive(TaskExecutionState state, DeployitConnection deployit, String deployitTaskId, DeployitTask task, DeployitServerDefinition deployitServer) {
        if (state == TaskExecutionState.PENDING) {
            deployit.getTaskService().start(deployitTaskId);
        }
    }

    private void archiveTaskIfExecuted(TaskWithSteps taskWithSteps, DeployitConnection deployit, String deployitTaskId) {
        if (taskWithSteps.getState() == TaskExecutionState.EXECUTED) {
            deployit.getTaskService().archive(deployitTaskId);
        }
    }

    private void handleException(DeployitConnection deployit, Runnable onException, String logMessage, Object ... params) {
        logger.info(logMessage, params);
        Closeables.closeQuietly((Closeable)deployit);
        if (null != onException) {
            onException.run();
        }
    }

    private BooterConfig getBooterConfig(DeployitTask task, DeployitServerDefinition deployitServer) {
        if (task.hasCredentials()) {
            URI uri = deployitServer.toUri();
            return BooterConfig.builder().withHost(uri.getHost()).withPort(uri.getPort()).withContext(uri.getPath()).withCredentials(task.getUsername(), task.getPassword()).build();
        }
        return deployitServer.getBooterConfig();
    }

    private class PollProcess
    implements Runnable {
        private DeployitTask taskDefinition;
        private DeployitConnection deployit;
        private DeployitServerDefinition deployitServer;
        private String deployitTaskId;
        private boolean updateTaskProgress;
        private Runnable onCompletion;
        private Runnable onFailure;

        public PollProcess(DeployitTask taskDefinition, DeployitConnection deployit, DeployitServerDefinition deployitServer, String deployitTaskId, boolean updateTaskProgress, Runnable onCompletion, Runnable onFailure) {
            this.taskDefinition = taskDefinition;
            this.deployit = deployit;
            this.deployitServer = deployitServer;
            this.deployitTaskId = deployitTaskId;
            this.updateTaskProgress = updateTaskProgress;
            this.onCompletion = onCompletion;
            this.onFailure = onFailure;
        }

        public void start() {
            DeploymentService.this.scheduler.scheduleAtFixedRate(this, 0L, 2L, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            TaskExecutionState state;
            TaskWithSteps taskWithSteps;
            try {
                if (this.deployit == null) {
                    this.deployit = DeploymentService.this.connections.connect(this.deployitServer.getBooterConfig());
                }
                taskWithSteps = this.deployit.getTaskService().getSteps(this.deployitTaskId);
                DeploymentService.this.startTaskIfInactive(taskWithSteps.getState(), this.deployit, this.deployitTaskId, this.taskDefinition, this.deployitServer);
                DeploymentService.this.archiveTaskIfExecuted(taskWithSteps, this.deployit, this.deployitTaskId);
            }
            catch (Exception exception) {
                logger.info("Error when connecting to deployit server: '{}', retrying in {} seconds", new Object[]{this.deployitServer, 60, exception});
                Closeables.closeQuietly((Closeable)this.deployit);
                this.deployit = null;
                DeploymentService.this.scheduler.cancel(this);
                DeploymentService.this.scheduler.scheduleAtFixedRate(this, 60L, 2L, TimeUnit.SECONDS);
                return;
            }
            if (this.updateTaskProgress) {
                this.updateTaskProgress(this.taskDefinition.getId(), taskWithSteps);
            }
            if (this.pollingComplete(state = taskWithSteps.getState())) {
                this.stopPolling(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTaskProgress(String releaseItTaskId, TaskWithSteps taskWithSteps) {
            try {
                Object object = ReleaseLock.of(releaseItTaskId);
                synchronized (object) {
                    DeployitTask task = (DeployitTask)DeploymentService.this.repositoryService.read(releaseItTaskId);
                    int currentStep = taskWithSteps.getCurrentStepNr();
                    int nrSteps = taskWithSteps.getNrSteps();
                    if (taskWithSteps.getState() == TaskExecutionState.EXECUTING && (task.getCurrentStep() != currentStep || task.getTotalStep() != nrSteps)) {
                        task.setCurrentStep(currentStep);
                        task.setTotalStep(nrSteps);
                        task.setCurrentStepTitle(taskWithSteps.getStep(currentStep).getDescription());
                        DeploymentService.this.repositoryService.update((ConfigurationItem[])new DeployitTask[]{task});
                    }
                }
            }
            catch (Exception exception) {
                logger.info("Unable to update XL Release task: '{}'", (Object)releaseItTaskId, (Object)exception);
            }
        }

        private boolean pollingComplete(TaskExecutionState state) {
            return state == TaskExecutionState.DONE || state == TaskExecutionState.EXECUTED || state == TaskExecutionState.STOPPED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopPolling(TaskExecutionState state) {
            try {
                if (state == TaskExecutionState.EXECUTED || state == TaskExecutionState.DONE) {
                    this.onCompletion.run();
                }
                if (state == TaskExecutionState.STOPPED) {
                    this.onFailure.run();
                }
            }
            catch (Exception exception) {
                logger.info("Unable to update XL Release task: '{}'on deployit completion/failure.", (Object)this.taskDefinition.getId(), (Object)exception);
            }
            finally {
                Closeables.closeQuietly((Closeable)this.deployit);
                DeploymentService.this.scheduler.cancel(this);
            }
        }
    }

    private class RollbackResultHandler
    implements Runnable {
        private String logMessage;

        public RollbackResultHandler(String logMessage) {
            this.logMessage = logMessage;
        }

        @Override
        public void run() {
            logger.info(this.logMessage);
        }
    }
}

