/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.reports.Duration;
import com.xebialabs.xlrelease.reports.NumberByMonthComputer;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseAutomation;
import com.xebialabs.xlrelease.reports.ReleaseAutomationComputer;
import com.xebialabs.xlrelease.reports.ReleaseDurationComputer;
import com.xebialabs.xlrelease.reports.ReportTimeFrame;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.TaskWithReleaseData;
import com.xebialabs.xlrelease.reports.TopTenSorter;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.reports.UserTask;
import com.xebialabs.xlrelease.repository.Reports;
import com.xebialabs.xlrelease.views.Point;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    private Reports reports;

    @Autowired
    public ReportService(Reports reports) {
        this.reports = reports;
    }

    public Map<String, List<Point>> getReleaseDurationSeries(ReportTimeFrame since) {
        return new ReleaseDurationComputer(this.reports.getReleasesDuration(since)).getSeries();
    }

    public List<UserParticipation> getTopTenPeopleMostInvolved(ReportTimeFrame since) {
        List<UserTask> tasks = this.reports.getUsersTasks(since);
        Comparator<UserParticipation> userParticipationComparator = new Comparator<UserParticipation>(){

            @Override
            public int compare(UserParticipation userParticipation1, UserParticipation userParticipation2) {
                return Float.compare(userParticipation2.getTimeSpent(), userParticipation1.getTimeSpent());
            }
        };
        return new TopTenSorter<UserParticipation>(this.getUserParticipations(tasks)).with(userParticipationComparator);
    }

    public List<TaskDuration> getTopTenLongestTasks(ReportTimeFrame since) {
        List<TaskDuration> tasks = this.reports.getTasksDuration(since);
        Comparator<TaskDuration> taskDurationComparator = new Comparator<TaskDuration>(){

            @Override
            public int compare(TaskDuration taskDuration1, TaskDuration taskDuration2) {
                return Float.compare(taskDuration2.getDuration(), taskDuration1.getDuration());
            }
        };
        return new TopTenSorter<TaskDuration>(tasks).with(taskDurationComparator);
    }

    public Map<String, List<Point>> getReleaseAutomationSeries(ReportTimeFrame since) {
        return new ReleaseAutomationComputer(this.getReleaseAutomation(since)).getSeries();
    }

    public List<PhaseDuration> getTopTenLongestPhases(ReportTimeFrame since) {
        List<PhaseDuration> phases = this.reports.getPhasesDuration(since);
        Comparator<PhaseDuration> phaseDurationComparator = new Comparator<PhaseDuration>(){

            @Override
            public int compare(PhaseDuration phaseDuration1, PhaseDuration phaseDuration2) {
                return Float.compare(phaseDuration2.getDuration(), phaseDuration1.getDuration());
            }
        };
        return new TopTenSorter<PhaseDuration>(phases).with(phaseDurationComparator);
    }

    public List<Point> getNumberOfReleaseByMonth(ReportTimeFrame since) {
        List<DateTime> releasesEndDate = this.reports.getReleasesEndDate(since);
        if (releasesEndDate.isEmpty()) {
            return Lists.newArrayList();
        }
        NumberByMonthComputer releaseByMonthComputer = new NumberByMonthComputer(releasesEndDate.get(0));
        for (DateTime releaseEndDate : releasesEndDate) {
            releaseByMonthComputer.add(releaseEndDate);
        }
        return releaseByMonthComputer.completeSerie(releasesEndDate.get(releasesEndDate.size() - 1));
    }

    private List<ReleaseAutomation> getReleaseAutomation(ReportTimeFrame since) {
        List<TaskWithReleaseData> tasksWithReleaseData = this.reports.getTasksWithReleaseData(since);
        HashMap releasesAutomationById = Maps.newHashMap();
        for (TaskWithReleaseData task : tasksWithReleaseData) {
            ReleaseAutomation releaseAutomation = (ReleaseAutomation)releasesAutomationById.get(task.getReleaseId());
            if (releaseAutomation == null) {
                releaseAutomation = new ReleaseAutomation(task.getReleaseTitle(), task.getReleaseEndDate());
                releasesAutomationById.put(task.getReleaseId(), releaseAutomation);
            }
            releaseAutomation.incrementNumberOfTask();
            float taskDuration = new Duration(task.getStartDate(), task.getEndDate()).compute();
            releaseAutomation.incrementTotalDuration(taskDuration);
            if (!task.isAutomated()) continue;
            releaseAutomation.incrementNumberAutomatedOfTasks();
            releaseAutomation.incrementAutomatedDuration(taskDuration);
        }
        return this.sortByReleaseEndDate(Lists.newArrayList(releasesAutomationById.values()));
    }

    private List<ReleaseAutomation> sortByReleaseEndDate(List<ReleaseAutomation> releasesAutomation) {
        Comparator<ReleaseAutomation> releasesAutomationComparator = new Comparator<ReleaseAutomation>(){

            @Override
            public int compare(ReleaseAutomation releaseAutomation1, ReleaseAutomation releaseAutomation2) {
                return releaseAutomation1.getEndDate().compareTo((ReadableInstant)releaseAutomation2.getEndDate());
            }
        };
        Collections.sort(releasesAutomation, releasesAutomationComparator);
        return releasesAutomation;
    }

    private List<UserParticipation> getUserParticipations(List<UserTask> tasks) {
        HashMap participationByUser = Maps.newHashMap();
        for (UserTask userTask : tasks) {
            float duration = new Duration(userTask.getStartDate(), userTask.getEndDate()).compute();
            UserParticipation userParticipation = (UserParticipation)participationByUser.get(userTask.getUser());
            if (userParticipation == null) {
                userParticipation = new UserParticipation();
                userParticipation.setUser(userTask.getUser());
                participationByUser.put(userTask.getUser(), userParticipation);
            }
            userParticipation.incrementTasksHandled();
            userParticipation.addTimeSpent(duration);
        }
        return Lists.newArrayList(participationByUser.values());
    }
}

