/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReportTimeFrame;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.service.ReportService;
import com.xebialabs.xlrelease.views.Point;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceCache {
    private ReportService reportService;
    public static final int EXPIRATION_DELAY_IN_HOUR = 1;
    private LoadingCache<ReportTimeFrame, Map<String, List<Point>>> releaseDurationCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportTimeFrame, Map<String, List<Point>>>(){

        public Map<String, List<Point>> load(ReportTimeFrame since) throws Exception {
            return ReportServiceCache.this.reportService.getReleaseDurationSeries(since);
        }
    });
    private LoadingCache<ReportTimeFrame, List<UserParticipation>> peopleMostInvolvedCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportTimeFrame, List<UserParticipation>>(){

        public List<UserParticipation> load(ReportTimeFrame since) throws Exception {
            return ReportServiceCache.this.reportService.getTopTenPeopleMostInvolved(since);
        }
    });
    private LoadingCache<ReportTimeFrame, List<TaskDuration>> longestTasksCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportTimeFrame, List<TaskDuration>>(){

        public List<TaskDuration> load(ReportTimeFrame since) throws Exception {
            return ReportServiceCache.this.reportService.getTopTenLongestTasks(since);
        }
    });
    private LoadingCache<ReportTimeFrame, Map<String, List<Point>>> releaseAutomationCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportTimeFrame, Map<String, List<Point>>>(){

        public Map<String, List<Point>> load(ReportTimeFrame since) throws Exception {
            return ReportServiceCache.this.reportService.getReleaseAutomationSeries(since);
        }
    });
    private LoadingCache<ReportTimeFrame, List<PhaseDuration>> longestPhasesCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportTimeFrame, List<PhaseDuration>>(){

        public List<PhaseDuration> load(ReportTimeFrame since) throws Exception {
            return ReportServiceCache.this.reportService.getTopTenLongestPhases(since);
        }
    });
    private LoadingCache<ReportTimeFrame, List<Point>> numberOfReleaseCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportTimeFrame, List<Point>>(){

        public List<Point> load(ReportTimeFrame since) throws Exception {
            return ReportServiceCache.this.reportService.getNumberOfReleaseByMonth(since);
        }
    });

    @Autowired
    public ReportServiceCache(ReportService reportService) {
        this.reportService = reportService;
    }

    public Map<String, List<Point>> getReleaseDurationSeries(ReportTimeFrame since) {
        try {
            return (Map)this.releaseDurationCache.get((Object)since);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<UserParticipation> getTopTenPeopleMostInvolved(ReportTimeFrame since) {
        try {
            return (List)this.peopleMostInvolvedCache.get((Object)since);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TaskDuration> getTopTenLongestTasks(ReportTimeFrame since) {
        try {
            return (List)this.longestTasksCache.get((Object)since);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<Point>> getReleaseAutomationSeries(ReportTimeFrame since) {
        try {
            return (Map)this.releaseAutomationCache.get((Object)since);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PhaseDuration> getTopTenLongestPhases(ReportTimeFrame since) {
        try {
            return (List)this.longestPhasesCache.get((Object)since);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Point> getNumberOfReleaseByMonth(ReportTimeFrame since) {
        try {
            return (List)this.numberOfReleaseCache.get((Object)since);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

