/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.views.DependencyNode;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class DependencyView {
    public static final Function<Dependency, DependencyView> TO_DEPENDENCY_VIEW = new Function<Dependency, DependencyView>(){

        public DependencyView apply(Dependency dependency) {
            return new DependencyView(dependency);
        }
    };
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String id;
    private DependencyNode target;
    private boolean resolved;

    public DependencyView() {
    }

    public DependencyView(Dependency dependency) {
        Object target = dependency.getTarget();
        this.id = dependency.getId();
        this.target = new DependencyNode((PlanItem)((Object)target));
        this.resolved = ((PlanItem)((Object)target)).isDone();
    }

    public DependencyView(String releaseId, String phaseId, String taskId) {
        this.target = new DependencyNode();
        this.target.setReleaseId(releaseId);
        this.target.setPhaseId(phaseId);
        this.target.setTaskId(taskId);
    }

    public String getId() {
        return this.id;
    }

    public DependencyNode getTarget() {
        return this.target;
    }

    public void setTarget(DependencyNode target) {
        this.target = target;
    }

    public String toTargetId() {
        return this.target.toNodeId();
    }

    public boolean isResolved() {
        return this.resolved;
    }
}

