/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PhaseFullView {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String id;
    private String title;
    private String description;
    private PhaseStatus status;
    private List<TaskFullView> tasks;
    private List<TaskFullView> startGates;
    private List<TaskFullView> endGates;
    private boolean startGatesOpen;
    private boolean endGatesOpen;
    private String color;
    private Date scheduledStartDate;
    private Date dueDate;
    private Date startDate;
    private Date endDate;
    public static final Function<Phase, PhaseFullView> TO_PHASE_FULL_VIEW = new Function<Phase, PhaseFullView>(){

        public PhaseFullView apply(Phase phase) {
            return new PhaseFullView(phase);
        }
    };

    public PhaseFullView() {
    }

    public PhaseFullView(Phase phase) {
        this.id = phase.getId();
        this.description = phase.getDescription();
        this.title = phase.getTitle();
        this.status = phase.getStatus();
        this.tasks = Lists.transform(phase.getTasks(), TaskFullView.TO_TASK_FULL_VIEW);
        this.startGates = Lists.transform(phase.getStartGates(), TaskFullView.TO_TASK_FULL_VIEW);
        this.endGates = Lists.transform(phase.getEndGates(), TaskFullView.TO_TASK_FULL_VIEW);
        this.startGatesOpen = phase.areStartGatesOpen();
        this.endGatesOpen = phase.areEndGatesOpen();
        this.color = phase.getColor();
        this.scheduledStartDate = phase.getScheduledStartDate();
        this.dueDate = phase.getDueDate();
        this.startDate = phase.getStartDate();
        this.endDate = phase.getEndDate();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PhaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(PhaseStatus status) {
        this.status = status;
    }

    public List<TaskFullView> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskFullView> tasks) {
        this.tasks = tasks;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<TaskFullView> getStartGates() {
        return this.startGates;
    }

    public List<TaskFullView> getEndGates() {
        return this.endGates;
    }

    public boolean isStartGatesOpen() {
        return this.startGatesOpen;
    }

    public boolean isEndGatesOpen() {
        return this.endGatesOpen;
    }

    public String getColor() {
        return this.color;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }
}

