/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ReleaseFullView {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String id;
    private String title;
    private String description;
    private ReleaseStatus status;
    private Date startDate;
    private Date scheduledStartDate;
    private Date endDate;
    private Date dueDate;
    private String currentPhase;
    private TaskFullView currentTask;
    private List<TaskFullView> currentSimpleTasks;
    private List<PhaseFullView> phases;
    private String owner;
    private List<Variable> variables;
    private List<String> tags;
    private Flag releaseFlag;
    private Flag flag;
    private String calendarLinkToken;
    private boolean calendarPublished;
    public static final Function<Release, ReleaseFullView> TO_RELEASE_FULL_VIEW = new Function<Release, ReleaseFullView>(){

        public ReleaseFullView apply(Release release) {
            return new ReleaseFullView(release);
        }
    };

    public ReleaseFullView() {
    }

    public ReleaseFullView(Release release) {
        this.id = release.getId();
        this.title = release.getTitle();
        this.description = release.getDescription();
        this.status = release.getStatus();
        this.startDate = release.getStartDate();
        this.scheduledStartDate = release.getScheduledStartDate();
        this.endDate = release.getEndDate();
        this.dueDate = release.getDueDate();
        this.owner = release.getOwner();
        this.phases = Lists.transform(release.getPhases(), PhaseFullView.TO_PHASE_FULL_VIEW);
        this.variables = Variable.getVariables(release);
        this.tags = release.getTags();
        this.releaseFlag = Flag.toItemFlag(release);
        this.flag = Flag.toFlag(release);
        this.calendarLinkToken = release.getCalendarLinkToken();
        this.calendarPublished = release.isCalendarPublished();
        if (release.hasCurrentPhase()) {
            Phase currentPhase = release.getCurrentPhase();
            this.currentPhase = currentPhase.getTitle();
            if (currentPhase.hasCurrentTask()) {
                Task currentTask = currentPhase.getCurrentTask();
                this.currentTask = new TaskFullView(currentTask);
                this.currentSimpleTasks = ReleaseFullView.flattenCurrentTask(currentTask);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public TaskFullView getCurrentTask() {
        return this.currentTask;
    }

    public List<TaskFullView> getCurrentSimpleTasks() {
        return this.currentSimpleTasks;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public List<PhaseFullView> getPhases() {
        return this.phases;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Flag getReleaseFlag() {
        return this.releaseFlag;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public String getCalendarLinkToken() {
        return this.calendarLinkToken;
    }

    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    @VisibleForTesting
    static List<TaskFullView> flattenCurrentTask(Task currentTask) {
        ArrayList currentTasks = Lists.newArrayList();
        if (currentTask.isParallelGroup()) {
            ReleaseFullView.collectCurrentSubTasks("", (ParallelGroup)currentTask, currentTasks);
        } else {
            currentTasks.add(new TaskFullView(currentTask));
        }
        return currentTasks;
    }

    private static void collectCurrentSubTasks(String parentPrefix, ParallelGroup group, List<TaskFullView> target) {
        String prefix = group.getTitle() + " / ";
        if (!parentPrefix.isEmpty()) {
            prefix = parentPrefix + prefix;
        }
        for (Task subTask : group.getTasks()) {
            if (subTask.isParallelGroup()) {
                ReleaseFullView.collectCurrentSubTasks(prefix, (ParallelGroup)subTask, target);
                continue;
            }
            if (!subTask.isActive()) continue;
            TaskFullView view = new TaskFullView(subTask);
            view.setTitle(prefix + view.getTitle());
            target.add(view);
        }
    }
}

