/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DefaultTaskTypes;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Task;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TaskForm {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String phaseId;
    private String title;
    private String taskType;

    public String getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(String phaseId) {
        this.phaseId = phaseId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Task toTask() {
        Task task = this.buildTask();
        task.setTitle(this.title);
        return task;
    }

    private Task buildTask() {
        Type type = Type.valueOf((String)this.taskType);
        if (DefaultTaskTypes.isDefaultTaskType(type)) {
            return (Task)type.getDescriptor().newInstance(null);
        }
        if (PythonScript.isScriptDefinition(type)) {
            PythonScript pythonScript = (PythonScript)type.getDescriptor().newInstance(null);
            CustomScriptTask task = (CustomScriptTask)DefaultTaskTypes.CUSTOM_SCRIPT_TASK.getType().getDescriptor().newInstance(null);
            task.setPythonScript(pythonScript);
            return task;
        }
        throw new IllegalArgumentException(String.format("Can only create tasks from default task types or subtypes of %s", PythonScript.AS_TYPE));
    }
}

