/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.deployit.plumbing.PasswordDeserializer;
import com.xebialabs.deployit.plumbing.PasswordSerializer;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DefaultTaskTypes;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.GateConditionView;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TaskFullView {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String id;
    private String title;
    private String description;
    private String owner;
    private String team;
    private String taskType;
    private String scriptDefinitionType;
    private TaskStatus status;
    private Flag flag = new Flag(FlagStatus.OK);
    private Date scheduledStartDate;
    private Date startDate;
    private Date dueDate;
    private Date endDate;
    private String phaseTitle;
    private String releaseTitle;
    private String addedComment;
    private int numberOfComments;
    private String releaseOwner;
    private String server;
    private String deploymentPackage;
    private String environment;
    private String username;
    @JsonSerialize(using=PasswordSerializer.class)
    @JsonDeserialize(using=PasswordDeserializer.class)
    private String password;
    private int currentStep;
    private int totalStep;
    private String currentStepTitle;
    private List<GateConditionView> conditions;
    private List<DependencyView> dependencies;
    private Set<String> addresses;
    private String subject;
    private String body;
    private String script;
    private List<TaskFullView> tasks;
    private boolean isAutomated;
    private Map<String, Object> inputProperties = Maps.newHashMap();
    private Map<String, String> outputProperties = Maps.newHashMap();
    public static final Function<Task, TaskFullView> TO_TASK_FULL_VIEW = new Function<Task, TaskFullView>(){

        public TaskFullView apply(Task task) {
            return new TaskFullView(task);
        }
    };

    public TaskFullView() {
    }

    public TaskFullView(Task task) {
        this.id = task.getId();
        this.title = task.getTitle();
        this.description = task.getDescription();
        this.status = task.getStatus();
        this.flag = Flag.toItemFlag(task);
        this.scheduledStartDate = task.getScheduledStartDate();
        this.startDate = task.getStartDate();
        this.dueDate = task.getDueDate();
        this.endDate = task.getEndDate();
        this.phaseTitle = task.getPhase().getTitle();
        this.releaseTitle = task.getPhase().getRelease().getTitle();
        this.owner = task.getOwner();
        this.releaseOwner = task.getPhase().getRelease().getOwner();
        this.team = task.getTeam();
        this.numberOfComments = task.getComments().size();
        this.isAutomated = (Boolean)task.getProperty("automated");
        if (task instanceof DeployitTask) {
            DeployitTask deployitTask = (DeployitTask)task;
            this.server = deployitTask.getServer();
            this.deploymentPackage = deployitTask.getDeploymentPackage();
            this.environment = deployitTask.getEnvironment();
            this.username = deployitTask.getUsername();
            this.password = deployitTask.getPassword();
            this.taskType = DefaultTaskTypes.DEPLOYIT.getTypeName();
            this.currentStep = deployitTask.getCurrentStep();
            this.totalStep = deployitTask.getTotalStep();
            this.currentStepTitle = deployitTask.getCurrentStepTitle();
        } else if (task instanceof GateTask) {
            this.taskType = DefaultTaskTypes.GATE.getTypeName();
            this.conditions = Lists.transform(((GateTask)task).getConditions(), GateConditionView.TO_CONDITION_VIEW);
            this.dependencies = Lists.transform(((GateTask)task).getDependencies(), DependencyView.TO_DEPENDENCY_VIEW);
        } else if (task instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task;
            this.taskType = DefaultTaskTypes.NOTIFICATION.getTypeName();
            this.addresses = notificationTask.getAddresses();
            this.subject = notificationTask.getSubject();
            this.body = notificationTask.getBody();
        } else if (task instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task;
            this.taskType = DefaultTaskTypes.SCRIPT.getTypeName();
            this.script = scriptTask.getScript();
        } else if (task instanceof ParallelGroup) {
            this.taskType = DefaultTaskTypes.PARALLEL_GROUP.getTypeName();
            this.tasks = Lists.transform(((ParallelGroup)task).getTasks(), TO_TASK_FULL_VIEW);
        } else if (task instanceof CustomScriptTask) {
            String propertyName;
            CustomScriptTask customScriptTask = (CustomScriptTask)task;
            PythonScript pythonScript = customScriptTask.getPythonScript();
            this.taskType = DefaultTaskTypes.CUSTOM_SCRIPT_TASK.getTypeName();
            this.scriptDefinitionType = pythonScript.getType().toString();
            for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
                propertyName = propertyDescriptor.getName();
                this.inputProperties.put(propertyName, pythonScript.getProperty(propertyName));
            }
            for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
                propertyName = propertyDescriptor.getName();
                this.outputProperties.put(propertyName, (String)pythonScript.getProperty(propertyName));
            }
        } else {
            this.taskType = task.getType().toString();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getScriptDefinitionType() {
        return this.scriptDefinitionType;
    }

    public void setScriptDefinitionType(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getPhaseTitle() {
        return this.phaseTitle;
    }

    public void setPhaseTitle(String phaseTitle) {
        this.phaseTitle = phaseTitle;
    }

    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public void setAddedComment(String addedComment) {
        this.addedComment = addedComment;
    }

    public String getAddedComment() {
        return this.addedComment;
    }

    public boolean hasAddedComment() {
        return this.addedComment != null;
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDeploymentPackage() {
        return this.deploymentPackage;
    }

    public void setDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public int getTotalStep() {
        return this.totalStep;
    }

    public void setTotalStep(int totalStep) {
        this.totalStep = totalStep;
    }

    public String getCurrentStepTitle() {
        return this.currentStepTitle;
    }

    public void setCurrentStepTitle(String currentStepTitle) {
        this.currentStepTitle = currentStepTitle;
    }

    public List<GateConditionView> getConditions() {
        return this.conditions;
    }

    public String getReleaseOwner() {
        return this.releaseOwner;
    }

    public List<DependencyView> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<String> addresses) {
        this.addresses = addresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public List<TaskFullView> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskFullView> tasks) {
        this.tasks = tasks;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAutomated() {
        return this.isAutomated;
    }

    public void setAutomated(boolean automated) {
        this.isAutomated = automated;
    }

    public Map<String, Object> getInputProperties() {
        return this.inputProperties;
    }

    public void setInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = inputProperties;
    }

    public Map<String, String> getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = outputProperties;
    }

    public boolean ownerHasBeenReassigned(Task task) {
        return !task.hasOwner() && this.hasOwner() || task.hasOwner() && !this.hasOwner() || task.hasOwner() && this.hasOwner() && !task.getOwner().equals(this.getOwner());
    }

    public boolean teamHasBeenReassigned(Task task) {
        return task.getTeam() == null && this.getTeam() != null || task.getTeam() != null && this.getTeam() == null || task.getTeam() != null && this.getTeam() != null && !task.getTeam().equals(this.getTeam());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskFullView taskView = (TaskFullView)o;
        if (this.addedComment != null ? !this.addedComment.equals(taskView.addedComment) : taskView.addedComment != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(taskView.description) : taskView.description != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals(taskView.dueDate) : taskView.dueDate != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(taskView.id) : taskView.id != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(taskView.owner) : taskView.owner != null) {
            return false;
        }
        if (this.phaseTitle != null ? !this.phaseTitle.equals(taskView.phaseTitle) : taskView.phaseTitle != null) {
            return false;
        }
        if (this.releaseTitle != null ? !this.releaseTitle.equals(taskView.releaseTitle) : taskView.releaseTitle != null) {
            return false;
        }
        if (this.status != taskView.status) {
            return false;
        }
        if (this.taskType != null ? !this.taskType.equals(taskView.taskType) : taskView.taskType != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(taskView.title) : taskView.title != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.taskType != null ? this.taskType.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        result = 31 * result + (this.phaseTitle != null ? this.phaseTitle.hashCode() : 0);
        result = 31 * result + (this.releaseTitle != null ? this.releaseTitle.hashCode() : 0);
        result = 31 * result + (this.addedComment != null ? this.addedComment.hashCode() : 0);
        return result;
    }
}

