/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.Team;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TeamView {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String id;
    private String teamName;
    private List<String> members = Lists.newArrayList();
    private List<String> permissions = Lists.newArrayList();
    public static final Function<Team, TeamView> TO_TEAM_VIEW = new Function<Team, TeamView>(){

        public TeamView apply(Team team) {
            return new TeamView(team);
        }
    };
    public static final Function<TeamView, Team> TO_TEAM = new Function<TeamView, Team>(){

        public Team apply(TeamView teamView) {
            return teamView.toTeam();
        }
    };

    public TeamView() {
    }

    public TeamView(Team team) {
        this.id = team.getId();
        this.teamName = team.getTeamName();
        this.members = team.getMembers();
        this.permissions = team.getPermissions();
    }

    public String getId() {
        return this.id;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public Team toTeam() {
        return TeamBuilder.newTeam().withId(this.id).withTeamName(this.teamName).withMembers(this.members).withPermissions(this.permissions).build();
    }
}

