/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemoteNodeTypeManager;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerNodeTypeManager
extends ServerObject
implements RemoteNodeTypeManager {
    private NodeTypeManager manager;

    public ServerNodeTypeManager(NodeTypeManager manager, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.manager = manager;
    }

    @Override
    public RemoteNodeType getNodeType(String name) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeType(this.manager.getNodeType(name));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteIterator getAllNodeTypes() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeTypeIterator(this.manager.getAllNodeTypes());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteIterator getPrimaryNodeTypes() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeTypeIterator(this.manager.getPrimaryNodeTypes());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteIterator getMixinNodeTypes() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeTypeIterator(this.manager.getMixinNodeTypes());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public boolean hasNodeType(String name) throws RepositoryException, RemoteException {
        try {
            return this.manager.hasNodeType(name);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void unregisterNodeTypes(String[] names) throws RepositoryException, RemoteException {
        try {
            this.manager.unregisterNodeTypes(names);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

