/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

public class ServerObject
extends UnicastRemoteObject {
    private RemoteAdapterFactory factory;

    protected ServerObject(RemoteAdapterFactory factory) throws RemoteException {
        super(factory.getPortNumber());
        this.factory = factory;
    }

    protected RemoteAdapterFactory getFactory() {
        return this.factory;
    }

    protected RepositoryException getRepositoryException(RepositoryException ex) {
        if (ex instanceof AccessDeniedException) {
            return new AccessDeniedException(ex.getMessage());
        }
        if (ex instanceof ConstraintViolationException) {
            return new ConstraintViolationException(ex.getMessage());
        }
        if (ex instanceof InvalidItemStateException) {
            return new InvalidItemStateException(ex.getMessage());
        }
        if (ex instanceof InvalidQueryException) {
            return new InvalidQueryException(ex.getMessage());
        }
        if (ex instanceof InvalidSerializedDataException) {
            return new InvalidSerializedDataException(ex.getMessage());
        }
        if (ex instanceof ItemExistsException) {
            return new ItemExistsException(ex.getMessage());
        }
        if (ex instanceof ItemNotFoundException) {
            return new ItemNotFoundException(ex.getMessage());
        }
        if (ex instanceof LockException) {
            return new LockException(ex.getMessage());
        }
        if (ex instanceof LoginException) {
            return new LoginException(ex.getMessage());
        }
        if (ex instanceof MergeException) {
            return new MergeException(ex.getMessage());
        }
        if (ex instanceof NamespaceException) {
            return new NamespaceException(ex.getMessage());
        }
        if (ex instanceof NoSuchNodeTypeException) {
            return new NoSuchNodeTypeException(ex.getMessage());
        }
        if (ex instanceof NoSuchWorkspaceException) {
            return new NoSuchWorkspaceException(ex.getMessage());
        }
        if (ex instanceof PathNotFoundException) {
            return new PathNotFoundException(ex.getMessage());
        }
        if (ex instanceof ReferentialIntegrityException) {
            return new ReferentialIntegrityException(ex.getMessage());
        }
        if (ex instanceof UnsupportedRepositoryOperationException) {
            return new UnsupportedRepositoryOperationException(ex.getMessage());
        }
        if (ex instanceof ValueFormatException) {
            return new ValueFormatException(ex.getMessage());
        }
        if (ex instanceof VersionException) {
            return new VersionException(ex.getMessage());
        }
        if (ex instanceof AccessControlException) {
            return new AccessControlException(ex.getMessage());
        }
        return new RepositoryException(ex.getMessage());
    }

    protected RemoteItem getRemoteItem(Item item) throws RemoteException {
        if (item instanceof Property) {
            return this.factory.getRemoteProperty((Property)item);
        }
        if (item instanceof Node) {
            return this.getRemoteNode((Node)item);
        }
        return this.factory.getRemoteItem(item);
    }

    protected RemoteNode getRemoteNode(Node node) throws RemoteException {
        if (node instanceof Version) {
            return this.factory.getRemoteVersion((Version)node);
        }
        if (node instanceof VersionHistory) {
            return this.factory.getRemoteVersionHistory((VersionHistory)node);
        }
        return this.factory.getRemoteNode(node);
    }

    protected RemoteNodeType[] getRemoteNodeTypeArray(NodeType[] types) throws RemoteException {
        if (types != null) {
            RemoteNodeType[] remotes = new RemoteNodeType[types.length];
            for (int i = 0; i < types.length; ++i) {
                remotes[i] = this.factory.getRemoteNodeType(types[i]);
            }
            return remotes;
        }
        return new RemoteNodeType[0];
    }

    protected Value[] getSerialValues(Value[] values) throws RepositoryException {
        ArrayList<Value> serials = new ArrayList<Value>();
        if (values != null) {
            for (Value value : values) {
                if (value == null) continue;
                serials.add(this.getSerialValue(value));
            }
        }
        return serials.toArray(new Value[serials.size()]);
    }

    protected Value getSerialValue(Value value) throws RepositoryException {
        if (value == null || value instanceof Serializable) {
            return value;
        }
        return SerialValueFactory.makeSerialValue(value);
    }
}

