/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;

public class UrlUriLocator
extends WildcardUriLocatorSupport {
    public static final String ALIAS = "uri";

    public boolean accept(String uri) {
        return UrlUriLocator.isValid(uri);
    }

    public static boolean isValid(String uri) {
        try {
            new URL(uri);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public InputStream locate(String uri) throws IOException {
        Validate.notNull((Object)uri, (String)"uri cannot be NULL!", (Object[])new Object[0]);
        if (this.getWildcardStreamLocator().hasWildcard(uri)) {
            String fullPath = FilenameUtils.getFullPath((String)uri);
            URL url = new URL(fullPath);
            return this.getWildcardStreamLocator().locateStream(uri, new File(URLDecoder.decode(url.getFile(), "UTF-8")));
        }
        URL url = new URL(uri);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        int timeout = this.getConnectionTimeout();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        return new BufferedInputStream(connection.getInputStream());
    }

    private int getConnectionTimeout() {
        return Context.isContextSet() ? Context.get().getConfig().getConnectionTimeout() : WroConfiguration.DEFAULT_CONNECTION_TIMEOUT;
    }
}

