/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.CSSMin;

@Minimize
@SupportedResourceType(value=ResourceType.CSS)
public class CssMinProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssMinProcessor.class);
    public static final String ALIAS = "cssMin";

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            String content = IOUtils.toString((Reader)reader);
            new CSSMin().formatFile(content, writer);
            writer.flush();
        }
        catch (Exception e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            String message = "Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource";
            LOG.error(message, (Throwable)e);
            throw new IOException(message);
        }
        finally {
            reader.close();
            writer.close();
        }
    }
}

