/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.change;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceChangeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceChangeInfo.class);
    private String currentHash;
    private String prevHash;
    private final Set<String> groups = Collections.synchronizedSet(new HashSet());

    public void updateHashForGroup(String hash, String groupName) {
        Validate.notNull((Object)groupName);
        this.currentHash = hash;
        if (this.isChangedHash()) {
            LOG.debug("[CHANGE] for group {}", (Object)groupName);
            this.groups.clear();
        }
    }

    private boolean isChangedHash() {
        return this.currentHash != null ? !this.currentHash.equals(this.prevHash) : this.prevHash != null;
    }

    public void reset() {
        if (this.currentHash != null) {
            this.prevHash = this.currentHash;
        }
        this.currentHash = null;
    }

    public boolean isChanged(String groupName) {
        boolean result;
        Validate.notNull((Object)groupName);
        boolean bl = this.isChangedHash() ? true : (result = !this.groups.contains(groupName));
        if (result) {
            this.groups.add(groupName);
            LOG.debug("ChangeDetails: {}", (Object)this);
        }
        String changedMessage = result ? "[YES]" : "[NO]";
        LOG.debug("{} changed for: {}, ", (Object)changedMessage, (Object)groupName);
        return result;
    }

    public boolean isCheckRequiredForGroup(String groupName) {
        Validate.notNull((Object)groupName);
        return this.currentHash == null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

