/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.esf;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class OtherRevRefs
extends ASN1Encodable {
    private ASN1ObjectIdentifier otherRevRefType;
    private ASN1Object otherRevRefs;

    public static OtherRevRefs getInstance(Object object) {
        if (object instanceof OtherRevRefs) {
            return (OtherRevRefs)object;
        }
        if (object != null) {
            return new OtherRevRefs(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("null value in getInstance");
    }

    private OtherRevRefs(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.otherRevRefType = new ASN1ObjectIdentifier(((DERObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId());
        try {
            this.otherRevRefs = ASN1Object.fromByteArray(aSN1Sequence.getObjectAt(1).getDERObject().getDEREncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public ASN1ObjectIdentifier getOtherRevRefType() {
        return this.otherRevRefType;
    }

    public ASN1Object getOtherRevRefs() {
        return this.otherRevRefs;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.otherRevRefType);
        aSN1EncodableVector.add(this.otherRevRefs);
        return new DERSequence(aSN1EncodableVector);
    }
}

