/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexRestCompatibilityServletResponse
extends HttpServletResponseWrapper {
    private int status = 200;
    private ServletOutputStream outputStream;
    private static final Logger logger = LoggerFactory.getLogger(FlexRestCompatibilityServletResponse.class);

    public FlexRestCompatibilityServletResponse(HttpServletResponse response) throws IOException {
        super(response);
        this.outputStream = response.getOutputStream();
    }

    public void writePreamble() throws IOException {
        this.outputStream.println("<response>");
        this.outputStream.println("<entity>");
    }

    public void writePostamble() throws IOException {
        this.outputStream.println("</entity>");
        this.outputStream.println(String.format("<status>%d</status>", this.status));
        this.outputStream.println("</response>");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void reset() {
        super.reset();
        try {
            this.writePreamble();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write flex compatibility preamble after resetting response.", e);
        }
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)this.outputStream);
    }

    public void setStatus(int sc) {
        int code = this._determineCorrectStatusCode(sc);
        super.setStatus(code);
    }

    private int _determineCorrectStatusCode(int sc) {
        this.addHeader("X-Original-Status", Integer.toString(sc));
        this.status = sc;
        if (sc >= 400 || sc == 204) {
            logger.info("Hiding status code {} with {}", (Object)sc, (Object)200);
            return 200;
        }
        return sc;
    }

    public void setStatus(int sc, String sm) {
        int code = this._determineCorrectStatusCode(sc);
        super.setStatus(code, sm);
    }

    public void sendError(int sc) throws IOException {
        int code = this._determineCorrectStatusCode(sc);
        super.sendError(code);
    }

    public void sendError(int sc, String msg) throws IOException {
        int code = this._determineCorrectStatusCode(sc);
        super.sendError(code, msg);
    }
}

