angular.module('xlrelease').value('CalendarConstants', {
    dayHeaderHeight: 20,
    releaseHeight: 26,
    border: 1
});

angular.module('xlrelease').factory('CalendarDisplay', ['Calendar', 'DateService', 'CalendarConstants', function (Calendar, DateService, CalendarConstants) {

    function computeReleaseOffsetTop(day) {
        return CalendarConstants.dayHeaderHeight + _.parseInt(day.css("padding-top"));
    }

    /**
     * Due to FireFox behavior, we can not use directly calendarContent.width() because it is not updated yet.
     * Instead we compute it by hand, according to navigator visibility.
     */
    function computeContentWidth(calendarContent) {
        var calendar = calendarContent.parents("#calendar");
        var navigator = calendar.find("#navigator");
        var contentWidth = calendar.width() - (_.parseInt(calendarContent.css("padding-right")) + _.parseInt(calendarContent.css("padding-left")));
        if (navigator.is(":visible")) {
            contentWidth = contentWidth - navigator.width();
        }
        return contentWidth;
    }

    return {
        positionPlanItem: function (element, planItem, index, isPhase) {
            var borderSize = isPhase ? 0 : CalendarConstants.border;
            // Used with phases to make sure they don't spill over release borders:
            var offset = isPhase ? CalendarConstants.border : 0;

            var day = element.parents(".week").find(".day:first");

            var planItemOffsetTop = computeReleaseOffsetTop(day);
            var dayWidth = _.parseInt(day.outerWidth());

            var elementWidth = (planItem.numberOfDay * dayWidth - 1 - (borderSize * 2) - (offset * 2)) + "px";
            element.css({
                top: (index * CalendarConstants.releaseHeight + planItemOffsetTop + offset) + "px",
                left: (planItem.leftDayOffset * dayWidth + offset) + "px",
                width: elementWidth
            });

            if (!isPhase) {
                this.resizeReleaseTitle(element);
            }
        },
        adjustWeekHeight: function (element, numberOfRelease) {
            var day = element.find(".day:first");

            var releaseOffsetTop = computeReleaseOffsetTop(day);
            var heightOfWeek = element.height();

            var idealHeight = numberOfRelease * CalendarConstants.releaseHeight + releaseOffsetTop;
            if (idealHeight > heightOfWeek) {
                var dayPadding = _.parseInt(day.css("padding-top")) + _.parseInt(day.css("padding-bottom"));
                element.height(idealHeight);
                element.find(".day").height(idealHeight - dayPadding);
            }
        },
        positionCurrentTime: function (element) {
            var dayWidth = element.parents('.day').outerWidth();
            var midnight = DateService.getToday();
            var currentTime = DateService.getTodayWithTime();

            var todayProgressRatio = currentTime.diff(midnight, 'days', true);
            element.css('left', todayProgressRatio * dayWidth);
        },
        resizeDays: function (calendarContent) {
            var calendarHeader = calendarContent.find("#days-name");
            var day = calendarContent.find(".day:first");

            var contentWidth = computeContentWidth(calendarContent);
            var dayPadding = _.parseInt(day.css("padding-right")) + _.parseInt(day.css("padding-left"));
            var dayWidth = _.parseInt(contentWidth / 7);
            var dayWidthWithoutPadding = dayWidth - (dayPadding + 1);
            var dayNumberWidth = 18;

            calendarContent.find("#days").css({"width": contentWidth});
            calendarHeader.css({"width": contentWidth + 1});
            calendarHeader.find("div").css({"width": dayWidth});
            calendarHeader.find("div:last").css({"width": dayWidth + 1});
            calendarContent.find(".day").css({"width": dayWidthWithoutPadding});
            calendarContent.find(".day-label").css({"width": dayWidthWithoutPadding - dayNumberWidth});
            calendarContent.find(".day-number").css({"width": dayNumberWidth});
        },
        resizeReleaseTitle: function (element) {
            var title = element.find('.title');
            var paddingHzl = 2 * _.parseInt(title.css('left'));
            title.width(title.parents('.release').width() - paddingHzl);
        }
    }
}]);

angular.module('xlrelease').directive('positionRelease', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element, attrs) {
        element.bind("mouseout mouseover", function () {
            element.parents('#days').find('.' + attrs.positionRelease).toggleClass('release-hover');
        });

        scope.$evalAsync(function () {
            CalendarDisplay.positionPlanItem(element, scope.release, scope.$index);
        });

        $(window).resize(function () {
            CalendarDisplay.positionPlanItem(element, scope.release, scope.$index);
        });

        scope.$watch('showNavigator', function () {
            scope.$evalAsync(function () {
                CalendarDisplay.positionPlanItem(element, scope.release, scope.$index);
            });
        });
    }
}]);

angular.module('xlrelease').directive('positionPhase', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        scope.$evalAsync(function () {
            CalendarDisplay.positionPlanItem(element, scope.phase, scope.$parent.$index, true);
        });

        $(window).resize(function () {
            CalendarDisplay.positionPlanItem(element, scope.phase, scope.$parent.$index, true);
        });

        scope.$watch('showNavigator', function () {
            CalendarDisplay.positionPlanItem(element, scope.phase, scope.$parent.$index, true);
        });
    }
}]);

angular.module('xlrelease').directive('adjustWeekHeight', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        scope.$watch('weeks', function () {
            CalendarDisplay.adjustWeekHeight(element, scope.week.releases.length);
        });
    }
}]);

angular.module('xlrelease').directive('positionCurrentTime', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        scope.$evalAsync(function () {
            CalendarDisplay.positionCurrentTime(element);
        });

        $(window).resize(function () {
            CalendarDisplay.positionCurrentTime(element);
        });

        scope.$watch('showNavigator', function () {
            CalendarDisplay.positionCurrentTime(element);
        });
    }
}]);

angular.module('xlrelease').directive('resizeDays', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        scope.$watchCollection('weeks', function () {
            scope.$evalAsync(function () {
                CalendarDisplay.resizeDays(element);
            });
        });

        $(window).resize(function () {
            CalendarDisplay.resizeDays(element);
        });

        scope.$watch('showNavigator', function () {
            CalendarDisplay.resizeDays(element);
        });
    };
}]);
