angular.module('xlrelease').factory('DeployitService', ['Backend', 'VariablesService', function (Backend, VariablesService) {
    function getAllPackages() {
        return Backend.get('deployit/packages');
    }

    function getAllEnvironments() {
        return Backend.get('deployit/environments');
    }

    function getAllEnvironmentsAndPackages(variables, setPackages, setEnvironments) {
        if (VariablesService.hasPackages(variables)) {
            getAllPackages().success(setPackages);
        }
        if (VariablesService.hasEnvironments(variables)) {
            getAllEnvironments().success(setEnvironments);
        }
    }

    return {
        getAllEnvironmentsAndPackages: getAllEnvironmentsAndPackages
    }
}]);
