angular.module('xlrelease').directive('dateEditor', function () {
    return {
        templateUrl: "partials/inline-editor/date.html",
        restrict: 'A',
        scope: {
            dateModel: '=',
            editable: '&',
            dateTitle: '@',
            noDateTitle: '@',
            addDateTitle: '@',
            onChange: '&'
        },
        link: function (scope) {
            scope.removeDate = function() {
                scope.dateModel = null;
            };
            scope.$watch('dateModel', function (newDate, oldDate) {
                if (angular.isUndefined(oldDate)) {
                    return;
                }
                if (newDate !== oldDate) {
                    scope.onChange();
                }
            });
        }
    }
});
