angular.module('xlrelease').directive('dateTimePicker', ['$parse', function ($parse) {
    var DATE_PICKER_FORMAT = 'MM-DD-YYYY';
    var TIME_PICKER_FORMAT = 'HH:mm';

    function overrideDatePart(oldDate, formattedDate) {
        var date = moment(formattedDate, DATE_PICKER_FORMAT).toDate();
        var newDate = new Date(oldDate);
        newDate.setDate(date.getDate());
        newDate.setMonth(date.getMonth());
        newDate.setFullYear(date.getFullYear());
        return newDate.valueOf();
    }

    function overrideTimePart(oldDate, time) {
        var newDate = new Date(oldDate);
        newDate.setHours(time.hours);
        newDate.setMinutes(time.minutes);
        return newDate.valueOf();
    }

    function saveDateAndClosePicker(scope, dateAccessor, date, datepickerHolder) {
        scope.$apply(function () {
            dateAccessor.assign(scope, overrideDatePart(getTodayIfDateIsNull(scope, dateAccessor), date));
        });
        datepickerHolder.datepicker('hide');
    }

    function setupDatePicker(element, scope, dateAccessor) {
        var datePickerHolder = element.find('.date-picker-holder');
        datePickerHolder.datepicker({
            format: DATE_PICKER_FORMAT.toLowerCase()
        });

        element.find('.date').on('click', function () {
            datePickerHolder.datepicker('show')
                .on('changeDate', function () {
                    saveDateAndClosePicker(scope, dateAccessor, datePickerHolder.data('date'), $(this));
                });
        });

        datePickerHolder.on('change', function () {
            saveDateAndClosePicker(scope, dateAccessor, $(this).val(), $(this));
        });
    }

    function setupTimePicker(element, scope, dateAccessor) {
        var timePickerHolder = element.find('.time-picker-holder');

        timePickerHolder.timepicker({
            showMeridian: false
        });
        element.find('.time').on('click', function () {
            timePickerHolder.timepicker('showWidget')
                .on('hide.timepicker', function (event) {
                    scope.$apply(function () {
                        dateAccessor.assign(scope, overrideTimePart(getTodayIfDateIsNull(scope, dateAccessor), event.time));
                    });
                });
        });
    }

    function getTodayIfDateIsNull(scope, dateAccessor) {
        if (dateAccessor(scope) === null) {
            var today = new Date();
            today.setSeconds(0);
            today.setMilliseconds(0);
            return today;
        }
        return dateAccessor(scope);
    }

    function setDateTime(element, scope, dateAccessor) {
        var date = getTodayIfDateIsNull(scope, dateAccessor);
        var formattedTime = moment(date).format(TIME_PICKER_FORMAT);

        var datePickerHolder = element.find('.date-picker-holder');
        datePickerHolder.datepicker('setDate', new Date(date));

        var timePickerHolder = element.find('.time-picker-holder');
        timePickerHolder.timepicker('setTime', formattedTime);
    }

    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            var dateAccessor = $parse(attrs['date']);
            var initialized = false;

            scope.$watch(attrs['date'], function (newDate) {
                if (angular.isDefined(newDate)) {
                    if (!initialized) {
                        setupDatePicker(element, scope, dateAccessor);
                        setupTimePicker(element, scope, dateAccessor);
                        initialized = true;
                    }

                    setDateTime(element, scope, dateAccessor);
                }
            });
        }
    }
}]);
