angular.module('xlrelease').factory('onClickOutsideService', [function () {
    return {
        setup: function (element, acceptTarget, action) {
            var clickHandler = function (event) {
                if (acceptTarget($(event.target))) {
                    action();
                }
            };

            $(document).on('click', clickHandler);
            element.on('$destroy', function () {
                $(document).off('click', clickHandler);
            });
        }
    }
}]);

angular.module('xlrelease').directive('onClickOutside', ['onClickOutsideService', '$parse', function (onClickOutsideService, $parse) {
    return function(scope, element, attrs) {
        var acceptTarget = function (target) {
            return !target.is(element) && !target.parents().is(element);
        };
        var action = function () {
            scope.$apply(function () {
                $parse(attrs['onClickOutside'])(scope);
            });
        };
        onClickOutsideService.setup(element, acceptTarget, action);
    }
}]);

angular.module('xlrelease').directive('closeOnBlur', ['onClickOutsideService', function (onClickOutsideService) {
    return function (scope, element) {
        var acceptTarget = function (target) {
            return !target.is('.dropdown-button') && target.parents('.dropdown-button').length !== 1 && !target.is('.popover') && target.parents('.popover').length !== 1
        };
        var action = function () {
            $('.popover.in').each(function () {
                $(this).popover('hide');
            });
        };
        onClickOutsideService.setup(element, acceptTarget, action);
    };
}]);

angular.module('xlrelease').directive('hidePopoverOnClick', function () {
    return function (scope, element) {
        element.on('click', function () {
            element.parents('.popover.in').each(function () {
                $(this).popover('hide');
            });
        });
    };
});
