angular.module('xlrelease').factory('tooltipService', [function () {
    return {
        setup: function (element, tooltip, position) {
            if (! position) {
                position = 'top';
            }

            element.attr('title', tooltip);
            element.tooltip('destroy');
            element.tooltip({placement: position, html: true, container: 'body'});
            element.on('$destroy', function () {
                element.tooltip('destroy');
            });
        }
    }
}]);

/**
 * Wraps bootstrap tooltip (see http://getbootstrap.com/2.3.2/javascript.html#tooltips)
 *
 * Usage:
 *      Static text :
 *          <span tooltip="'tooltip content'" tooltip-position="top | bottom | left | right"></span>
 *      Dynamic property (here object.property) :
 *          <span tooltip="object.property" tooltip-position="top | bottom | left | right"></span>
 *
 * The tooltip-position attribute is optional, default value is "top".
 * HTML gets escaped.
 */
angular.module('xlrelease').directive('tooltip', ['tooltipService', function (tooltipService) {
    return {
        restrict:'A',
        link: function (scope, element, attrs) {
            scope.$watch(attrs.tooltip, function (value) {
                tooltipService.setup(element, _.escape(value), attrs.tooltipPosition);
            });
        }
    }
}]);
