angular.module('xlrelease')
    .filter('dateFormatter', function () {
        return function (inputDate) {
            if (_(inputDate).isUndefined() || _(inputDate).isNull()) {
                return undefined;
            }
            if (moment().isSame(inputDate, 'day')) {
                return "Today";
            }
            return moment(inputDate).format("DD MMM YYYY");
        }
    })
    .filter('statusFormatter', function () {
        var statuses = {
            "TEMPLATE": "Template",
            "PLANNED": "Planned",
            "IN_PROGRESS": "In progress",
            "COMPLETED": "Completed",
            "FAILED": "Failed"
        };
        return function (inputStatus) {
            return statuses[inputStatus];
        }
    })
    .filter('newlines', function () {
        return function(text) {
            if (_(text).isUndefined() || _(text).isNull()) {
                return text;
            }
            return text
                .replace(/\n/g, '<br/>')
                .replace(/\s/g, '&nbsp;');
        }
    })
    .filter('noHTML', function () {
        return function(text) {
            if (_(text).isUndefined() || _(text).isNull()) {
                return text;
            }
            return text
                .replace(/&/g, '&amp;')
                .replace(/>/g, '&gt;')
                .replace(/</g, '&lt;');
        }
    })
    .filter('releaseSubpageFormatter', function () {
        var pages = {
            "EDITOR": "Release flow",
            "SUMMARY": "Release summary",
            "PROPERTIES": "Properties",
            "TEAMS": "Teams",
            "PERMISSIONS": "Permissions",
            "LOGS": "Activity logs"
        };
        return function(pageKey) {
            return pages[pageKey];
        }
    })
    .filter('markdown', function () {
        return function (text) {
            if (!text) {
                return '';
            }
            return marked(text
                .replace(/</g, '&lt;')
                .replace(/>/g, '&gt;')
            );
        };
    });
