'use strict';

angular.module('xlrelease').factory('FlagService', [function () {

    var NOT_FLAGGED_STATUS = 'OK';
    var ATTENTION_NEEDED_STATUS = 'ATTENTION_NEEDED';
    var AT_RISK_STATUS = 'AT_RISK';

    function isItemFlagged(item) {
        return item && item.flag && item.flag.status !== NOT_FLAGGED_STATUS;
    }

    function isFlaggedAttentionNeeded(item) {
        return isItemFlagged(item) && item.flag.status === ATTENTION_NEEDED_STATUS;
    }

    function isFlaggedAtRisk(item) {
        return isItemFlagged(item) && item.flag.status === AT_RISK_STATUS;
    }

    function isReleaseFlagged(release) {
        return release && release.releaseFlag && release.releaseFlag.status !== NOT_FLAGGED_STATUS;
    }

    return {
        NOT_FLAGGED_STATUS: NOT_FLAGGED_STATUS,
        isReleaseOrSubtaskFlagged: isItemFlagged,
        isReleaseFlagged: isReleaseFlagged,
        isTaskFlagged: isItemFlagged,
        isItemFlagged: isItemFlagged,
        isFlaggedAttentionNeeded: isFlaggedAttentionNeeded,
        isFlaggedAtRisk: isFlaggedAtRisk
    };
}]);
