'use strict';

angular.module('xlrelease').controller('mainController', ['$rootScope', '$scope', '$location', 'Authenticator', 'Backend', function ($rootScope, $scope, $location, Authenticator, Backend) {

    Backend.get('server/version').success(function (version) {
        $scope.version = version;
    });

    $scope.getClass = function (path) {
        if ($location.path().substr(0, path.length) == path) {
            return 'active'
        } else {
            return ''
        }
    };

    var fullPages = ['/login', '/invalid-license'];
    $scope.isFullPage = function () {
        return _.contains(fullPages, $location.path().substr(0, $location.path().length));
    };

    $scope.logout = function () {
        Authenticator.logout();
    };

    $rootScope.$on('ALERT', function (event, emittedAlert) {
        var alert = angular.extend({
            type: 'alert-error',
            message: 'An error occurred.'
        }, emittedAlert);

        $scope.alerts = [];
        $scope.alerts.push(alert);
        setTimeout(function () {
            $scope.$apply(function () {
                $scope.alerts = _.without($scope.alerts, alert);
            })
        }, 3000);
    });

    $rootScope.$on('CLEAR-ALERT', function () {
        $scope.alerts = [];
    });
}]);
