'use strict';

angular.module('xlrelease').controller('loginController', ['$scope', 'Authenticator', function ($scope, Authenticator) {
    $scope.loginInfo = {
        login: "",
        password: "",
        failed: false
    };

    $scope.login = function () {
        Authenticator.login($scope.loginInfo.login, $scope.loginInfo.password)
            .success(function () {
                $scope.loginInfo.failed = false;
            })
            .error(function (response, status) {
                $scope.loginInfo.failed = true;
                $scope.loginInfo.failedStatus = status;
                $scope.loginInfo.password = "";
            });
    };
}]);
