angular.module('xlrelease').factory('gatesTooltipService', ['VariablesInterpolator', function (VariablesInterpolator) {
    return {
        formatGates: function(gates, variables) {
            // Gets the titles and escape them
            var gatesTitles =  _.pluck(gates, 'title');
            gatesTitles = _.map(gatesTitles, _.escape);

            // Apply variables on titles.
            var interpolateInHtml = _.partial(VariablesInterpolator.interpolateInHtml, variables);
            gatesTitles = _.map(gatesTitles, interpolateInHtml);

            // Add new lines between gates
            return _.reduce(gatesTitles, function (text, item, index) {
                var firstLine = (index === 0);
                return firstLine ? item : text + "<br/>" + item;
            }, '');
        }
    }
}]);

angular.module('xlrelease').directive('gatesTooltip', ['gatesTooltipService', 'tooltipService', function (gatesTooltipService, tooltipService) {

    function notNull(value, defaultValue) {
        return value ? value : defaultValue;
    }

    return {
        restrict:'A',
        link: function(scope, element, attrs) {
            scope.$watch('[' + attrs.gates + ', ' + attrs.variables + ']', function (watchedValues) {
                var gates = notNull(watchedValues[0], []);
                var variables = watchedValues[1];

                var html = gatesTooltipService.formatGates(gates, variables);

                tooltipService.setup(element, html, 'right');
            }, true);
        }
    }
}]);
