'use strict';

angular.module('xlrelease').controller('phaseDetailsController', ['$scope', function ($scope) {
    $scope.$watch('phase.scheduledStartDate + phase.dueDate', validatePhaseDates);

    function validatePhaseDates() {
        $scope.warning = {
            displayScheduledStartDateBefore: $scope.phase.scheduledStartDate !== null && moment($scope.phase.scheduledStartDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
            displayScheduledStartDateAfter: $scope.phase.scheduledStartDate !== null && moment($scope.phase.scheduledStartDate).isAfter(moment($scope.release.dueDate), 'minutes'),
            displayDueDateBefore: $scope.phase.dueDate !== null && moment($scope.phase.dueDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
            displayDueDateAfter: $scope.phase.dueDate !== null && moment($scope.phase.dueDate).isAfter(moment($scope.release.dueDate), 'minutes')
        };
    }

    $scope.isEditable = function () {
        return !$scope.isPhaseReadOnly($scope.phase) && $scope.security.hasEditPermission($scope.release)
    };
}]);
